#! @AWK@ -f

#######################################################################
#
#   Gtk wrapper creation script (enumerations)
#
########################################################################


#######################################################################
#
# Copyright 2001, 2003 Free Software Foundation, Inc.
# Written by Paolo Bonzini and Dragomir Milivojevic
#
# This file is part of the GNU Smalltalk class library.
#
# The GNU Smalltalk class library is free software; you can redistribute it
# and/or modify it under the terms of the GNU Lesser General Public License
# as published by the Free Software Foundation; either version 2.1, or (at
# your option) any later version.
# 
# The GNU Smalltalk class library is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
# General Public License for more details.
# 
# You should have received a copy of the GNU Lesser General Public License
# along with the GNU Smalltalk class library; see the file COPYING.LESSER.
# If not, write to the Free Software Foundation, 59 Temple Place - Suite
# 330, Boston, MA 02110-1301, USA.  
#
########################################################################

BEGIN {
  print "/* Automatically generated, do not edit! */"
  print "#define GDK_PIXBUF_ENABLE_BACKEND 1"
  print "#include <stdio.h>"
  print "#include <stdlib.h>"
  print "#include <glib.h>"
  print "#include <glib-object.h>"
  print "#include <atk/atk.h>"
  print "#include <pango/pango.h>"
  print "#include <gtk/gtk.h>"
  print "#include <gdk/gdk.h>"
  print "#include <gdk/gdkkeysyms.h>"
}

FNR == 1 {
  enum_class = get_enum_class(FILENAME)
}

# store declaration in decl[filename]
/^(typedef )?enum/ {
  last_was_string = 0
  split("", declaration)

  do
    getline
  while (/^{/)

  while (! /^}/) {
    sub(/[,=].*/, "")
    if ($1 ~ /^[A-Z_][A-Z_0-9]*$/) declaration[$1] = ""
    getline
  }

  # On the last line, read the enum's name --------------
  if (NF != 2)
    enum_category = "enumerations"
  else {
    enum_category = $2
    sub(/;$/, "", enum_category)
    enum_class = get_enum_class(enum_category)
  }

  # And finally emit the code ---------------------------
  for (each in declaration) {
    decl[n++] = print_numeric_enum(each)
  }

  print_end_of_category()

  enums[m++] = enum_class " " enum_category " " n
}

END {
  print "int"
  print "main() {"
  print "  printf (\"\\\"Automatically generated, do not edit!\\\"\\n\");"
  n = 0
  for (i = 0; i < m; i++)
    {
      $0 = enums[i]
      print print_methodsFor($1, $2)
      while(n < $3)
        print decl[n++]
      print print_end_of_category()
    }

  print print_methodsFor("GValue", "fundamental types")
  print print_numeric_enum("G_TYPE_INVALID")
  print print_numeric_enum("G_TYPE_NONE")
  print print_numeric_enum("G_TYPE_INTERFACE")
  print print_numeric_enum("G_TYPE_CHAR")
  print print_numeric_enum("G_TYPE_UCHAR")
  print print_numeric_enum("G_TYPE_BOOLEAN")
  print print_numeric_enum("G_TYPE_INT")
  print print_numeric_enum("G_TYPE_UINT")
  print print_numeric_enum("G_TYPE_LONG")
  print print_numeric_enum("G_TYPE_ULONG")
  print print_numeric_enum("G_TYPE_INT64")
  print print_numeric_enum("G_TYPE_UINT64")
  print print_numeric_enum("G_TYPE_ENUM")
  print print_numeric_enum("G_TYPE_FLAGS")
  print print_numeric_enum("G_TYPE_FLOAT")
  print print_numeric_enum("G_TYPE_DOUBLE")
  print print_numeric_enum("G_TYPE_STRING")
  print print_numeric_enum("G_TYPE_POINTER")
  print print_numeric_enum("G_TYPE_BOXED")
  print print_numeric_enum("G_TYPE_PARAM")
  print print_numeric_enum("G_TYPE_OBJECT")
  print print_end_of_category()

  print print_methodsFor("Gtk", "stock objects")
  print print_string_enum("GTK_STOCK_DIALOG_INFO")
  print print_string_enum("GTK_STOCK_DIALOG_WARNING")
  print print_string_enum("GTK_STOCK_DIALOG_ERROR")
  print print_string_enum("GTK_STOCK_DIALOG_QUESTION")
  print print_string_enum("GTK_STOCK_DND")
  print print_string_enum("GTK_STOCK_DND_MULTIPLE")
  print print_string_enum("GTK_STOCK_ADD  ")
  print print_string_enum("GTK_STOCK_APPLY")
  print print_string_enum("GTK_STOCK_BOLD ")
  print print_string_enum("GTK_STOCK_CANCEL")
  print print_string_enum("GTK_STOCK_CDROM")
  print print_string_enum("GTK_STOCK_CLEAR")
  print print_string_enum("GTK_STOCK_CLOSE")
  print print_string_enum("GTK_STOCK_COLOR_PICKER")
  print print_string_enum("GTK_STOCK_CONVERT")
  print print_string_enum("GTK_STOCK_COPY")
  print print_string_enum("GTK_STOCK_CUT")
  print print_string_enum("GTK_STOCK_DELETE")
  print print_string_enum("GTK_STOCK_EXECUTE")
  print print_string_enum("GTK_STOCK_FIND")
  print print_string_enum("GTK_STOCK_FIND_AND_REPLACE")
  print print_string_enum("GTK_STOCK_FLOPPY")
  print print_string_enum("GTK_STOCK_GOTO_BOTTOM")
  print print_string_enum("GTK_STOCK_GOTO_FIRST")
  print print_string_enum("GTK_STOCK_GOTO_LAST")
  print print_string_enum("GTK_STOCK_GOTO_TOP")
  print print_string_enum("GTK_STOCK_GO_BACK")
  print print_string_enum("GTK_STOCK_GO_DOWN")
  print print_string_enum("GTK_STOCK_GO_FORWARD")
  print print_string_enum("GTK_STOCK_GO_UP")
  print print_string_enum("GTK_STOCK_HELP")
  print print_string_enum("GTK_STOCK_HOME")
  print print_string_enum("GTK_STOCK_INDEX")
  print print_string_enum("GTK_STOCK_ITALIC")
  print print_string_enum("GTK_STOCK_JUMP_TO")
  print print_string_enum("GTK_STOCK_JUSTIFY_CENTER")
  print print_string_enum("GTK_STOCK_JUSTIFY_FILL")
  print print_string_enum("GTK_STOCK_JUSTIFY_LEFT")
  print print_string_enum("GTK_STOCK_JUSTIFY_RIGHT")
  print print_string_enum("GTK_STOCK_MISSING_IMAGE")
  print print_string_enum("GTK_STOCK_NEW")
  print print_string_enum("GTK_STOCK_NO")
  print print_string_enum("GTK_STOCK_OK")
  print print_string_enum("GTK_STOCK_OPEN")
  print print_string_enum("GTK_STOCK_PASTE")
  print print_string_enum("GTK_STOCK_PREFERENCES")
  print print_string_enum("GTK_STOCK_PRINT")
  print print_string_enum("GTK_STOCK_PRINT_PREVIEW")
  print print_string_enum("GTK_STOCK_PROPERTIES")
  print print_string_enum("GTK_STOCK_QUIT")
  print print_string_enum("GTK_STOCK_REDO")
  print print_string_enum("GTK_STOCK_REFRESH")
  print print_string_enum("GTK_STOCK_REMOVE")
  print print_string_enum("GTK_STOCK_REVERT_TO_SAVED")
  print print_string_enum("GTK_STOCK_SAVE")
  print print_string_enum("GTK_STOCK_SAVE_AS")
  print print_string_enum("GTK_STOCK_SELECT_COLOR")
  print print_string_enum("GTK_STOCK_SELECT_FONT")
  print print_string_enum("GTK_STOCK_SORT_ASCENDING")
  print print_string_enum("GTK_STOCK_SORT_DESCENDING")
  print print_string_enum("GTK_STOCK_SPELL_CHECK")
  print print_string_enum("GTK_STOCK_STOP")
  print print_string_enum("GTK_STOCK_STRIKETHROUGH")
  print print_string_enum("GTK_STOCK_UNDELETE")
  print print_string_enum("GTK_STOCK_UNDERLINE")
  print print_string_enum("GTK_STOCK_UNDO")
  print print_string_enum("GTK_STOCK_YES")
  print print_string_enum("GTK_STOCK_ZOOM_100")
  print print_string_enum("GTK_STOCK_ZOOM_FIT")
  print print_string_enum("GTK_STOCK_ZOOM_IN")
  print print_string_enum("GTK_STOCK_ZOOM_OUT")
  print print_end_of_category()

  print print_methodsFor("Gdk", "key symbols")
  print print_numeric_define("GDK_VoidSymbol")
  print print_numeric_define("GDK_BackSpace")
  print print_numeric_define("GDK_Tab")
  print print_numeric_define("GDK_Linefeed")
  print print_numeric_define("GDK_Clear")
  print print_numeric_define("GDK_Return")
  print print_numeric_define("GDK_Pause")
  print print_numeric_define("GDK_Scroll_Lock")
  print print_numeric_define("GDK_Sys_Req")
  print print_numeric_define("GDK_Escape")
  print print_numeric_define("GDK_Delete")
  print print_numeric_define("GDK_Multi_key")
  print print_numeric_define("GDK_Codeinput")
  print print_numeric_define("GDK_SingleCandidate")
  print print_numeric_define("GDK_MultipleCandidate")
  print print_numeric_define("GDK_PreviousCandidate")
  print print_numeric_define("GDK_Kanji")
  print print_numeric_define("GDK_Muhenkan")
  print print_numeric_define("GDK_Henkan_Mode")
  print print_numeric_define("GDK_Henkan")
  print print_numeric_define("GDK_Romaji")
  print print_numeric_define("GDK_Hiragana")
  print print_numeric_define("GDK_Katakana")
  print print_numeric_define("GDK_Hiragana_Katakana")
  print print_numeric_define("GDK_Zenkaku")
  print print_numeric_define("GDK_Hankaku")
  print print_numeric_define("GDK_Zenkaku_Hankaku")
  print print_numeric_define("GDK_Touroku")
  print print_numeric_define("GDK_Massyo")
  print print_numeric_define("GDK_Kana_Lock")
  print print_numeric_define("GDK_Kana_Shift")
  print print_numeric_define("GDK_Eisu_Shift")
  print print_numeric_define("GDK_Eisu_toggle")
  print print_numeric_define("GDK_Kanji_Bangou")
  print print_numeric_define("GDK_Zen_Koho")
  print print_numeric_define("GDK_Mae_Koho")
  print print_numeric_define("GDK_Home")
  print print_numeric_define("GDK_Left")
  print print_numeric_define("GDK_Up")
  print print_numeric_define("GDK_Right")
  print print_numeric_define("GDK_Down")
  print print_numeric_define("GDK_Prior")
  print print_numeric_define("GDK_Page_Up")
  print print_numeric_define("GDK_Next")
  print print_numeric_define("GDK_Page_Down")
  print print_numeric_define("GDK_End")
  print print_numeric_define("GDK_Begin")
  print print_numeric_define("GDK_Select")
  print print_numeric_define("GDK_Print")
  print print_numeric_define("GDK_Execute")
  print print_numeric_define("GDK_Insert")
  print print_numeric_define("GDK_Undo")
  print print_numeric_define("GDK_Redo")
  print print_numeric_define("GDK_Menu")
  print print_numeric_define("GDK_Find")
  print print_numeric_define("GDK_Cancel")
  print print_numeric_define("GDK_Help")
  print print_numeric_define("GDK_Break")
  print print_numeric_define("GDK_Mode_switch")
  print print_numeric_define("GDK_script_switch")
  print print_numeric_define("GDK_Num_Lock")
  print print_numeric_define("GDK_KP_Space")
  print print_numeric_define("GDK_KP_Tab")
  print print_numeric_define("GDK_KP_Enter")
  print print_numeric_define("GDK_KP_F1")
  print print_numeric_define("GDK_KP_F2")
  print print_numeric_define("GDK_KP_F3")
  print print_numeric_define("GDK_KP_F4")
  print print_numeric_define("GDK_KP_Home")
  print print_numeric_define("GDK_KP_Left")
  print print_numeric_define("GDK_KP_Up")
  print print_numeric_define("GDK_KP_Right")
  print print_numeric_define("GDK_KP_Down")
  print print_numeric_define("GDK_KP_Prior")
  print print_numeric_define("GDK_KP_Page_Up")
  print print_numeric_define("GDK_KP_Next")
  print print_numeric_define("GDK_KP_Page_Down")
  print print_numeric_define("GDK_KP_End")
  print print_numeric_define("GDK_KP_Begin")
  print print_numeric_define("GDK_KP_Insert")
  print print_numeric_define("GDK_KP_Delete")
  print print_numeric_define("GDK_KP_Equal")
  print print_numeric_define("GDK_KP_Multiply")
  print print_numeric_define("GDK_KP_Add")
  print print_numeric_define("GDK_KP_Separator")
  print print_numeric_define("GDK_KP_Subtract")
  print print_numeric_define("GDK_KP_Decimal")
  print print_numeric_define("GDK_KP_Divide")
  print print_numeric_define("GDK_KP_0")
  print print_numeric_define("GDK_KP_1")
  print print_numeric_define("GDK_KP_2")
  print print_numeric_define("GDK_KP_3")
  print print_numeric_define("GDK_KP_4")
  print print_numeric_define("GDK_KP_5")
  print print_numeric_define("GDK_KP_6")
  print print_numeric_define("GDK_KP_7")
  print print_numeric_define("GDK_KP_8")
  print print_numeric_define("GDK_KP_9")
  print print_numeric_define("GDK_F1")
  print print_numeric_define("GDK_F2")
  print print_numeric_define("GDK_F3")
  print print_numeric_define("GDK_F4")
  print print_numeric_define("GDK_F5")
  print print_numeric_define("GDK_F6")
  print print_numeric_define("GDK_F7")
  print print_numeric_define("GDK_F8")
  print print_numeric_define("GDK_F9")
  print print_numeric_define("GDK_F10")
  print print_numeric_define("GDK_F11")
  print print_numeric_define("GDK_L1")
  print print_numeric_define("GDK_F12")
  print print_numeric_define("GDK_L2")
  print print_numeric_define("GDK_F13")
  print print_numeric_define("GDK_L3")
  print print_numeric_define("GDK_F14")
  print print_numeric_define("GDK_L4")
  print print_numeric_define("GDK_F15")
  print print_numeric_define("GDK_L5")
  print print_numeric_define("GDK_F16")
  print print_numeric_define("GDK_L6")
  print print_numeric_define("GDK_F17")
  print print_numeric_define("GDK_L7")
  print print_numeric_define("GDK_F18")
  print print_numeric_define("GDK_L8")
  print print_numeric_define("GDK_F19")
  print print_numeric_define("GDK_L9")
  print print_numeric_define("GDK_F20")
  print print_numeric_define("GDK_L10")
  print print_numeric_define("GDK_F21")
  print print_numeric_define("GDK_R1")
  print print_numeric_define("GDK_F22")
  print print_numeric_define("GDK_R2")
  print print_numeric_define("GDK_F23")
  print print_numeric_define("GDK_R3")
  print print_numeric_define("GDK_F24")
  print print_numeric_define("GDK_R4")
  print print_numeric_define("GDK_F25")
  print print_numeric_define("GDK_R5")
  print print_numeric_define("GDK_F26")
  print print_numeric_define("GDK_R6")
  print print_numeric_define("GDK_F27")
  print print_numeric_define("GDK_R7")
  print print_numeric_define("GDK_F28")
  print print_numeric_define("GDK_R8")
  print print_numeric_define("GDK_F29")
  print print_numeric_define("GDK_R9")
  print print_numeric_define("GDK_F30")
  print print_numeric_define("GDK_R10")
  print print_numeric_define("GDK_F31")
  print print_numeric_define("GDK_R11")
  print print_numeric_define("GDK_F32")
  print print_numeric_define("GDK_R12")
  print print_numeric_define("GDK_F33")
  print print_numeric_define("GDK_R13")
  print print_numeric_define("GDK_F34")
  print print_numeric_define("GDK_R14")
  print print_numeric_define("GDK_F35")
  print print_numeric_define("GDK_R15")
  print print_numeric_define("GDK_Shift_L")
  print print_numeric_define("GDK_Shift_R")
  print print_numeric_define("GDK_Control_L")
  print print_numeric_define("GDK_Control_R")
  print print_numeric_define("GDK_Caps_Lock")
  print print_numeric_define("GDK_Shift_Lock")
  print print_numeric_define("GDK_Meta_L")
  print print_numeric_define("GDK_Meta_R")
  print print_numeric_define("GDK_Alt_L")
  print print_numeric_define("GDK_Alt_R")
  print print_numeric_define("GDK_Super_L")
  print print_numeric_define("GDK_Super_R")
  print print_numeric_define("GDK_Hyper_L")
  print print_numeric_define("GDK_Hyper_R")
  print print_numeric_define("GDK_ISO_Lock")
  print print_numeric_define("GDK_ISO_Level2_Latch")
  print print_numeric_define("GDK_ISO_Level3_Shift")
  print print_numeric_define("GDK_ISO_Level3_Latch")
  print print_numeric_define("GDK_ISO_Level3_Lock")
  print print_numeric_define("GDK_ISO_Level5_Shift")
  print print_numeric_define("GDK_ISO_Level5_Latch")
  print print_numeric_define("GDK_ISO_Level5_Lock")
  print print_numeric_define("GDK_ISO_Group_Shift")
  print print_numeric_define("GDK_ISO_Group_Latch")
  print print_numeric_define("GDK_ISO_Group_Lock")
  print print_numeric_define("GDK_ISO_Next_Group")
  print print_numeric_define("GDK_ISO_Next_Group_Lock")
  print print_numeric_define("GDK_ISO_Prev_Group")
  print print_numeric_define("GDK_ISO_Prev_Group_Lock")
  print print_numeric_define("GDK_ISO_First_Group")
  print print_numeric_define("GDK_ISO_First_Group_Lock")
  print print_numeric_define("GDK_ISO_Last_Group")
  print print_numeric_define("GDK_ISO_Last_Group_Lock")
  print print_numeric_define("GDK_ISO_Left_Tab")
  print print_numeric_define("GDK_ISO_Move_Line_Up")
  print print_numeric_define("GDK_ISO_Move_Line_Down")
  print print_numeric_define("GDK_ISO_Partial_Line_Up")
  print print_numeric_define("GDK_ISO_Partial_Line_Down")
  print print_numeric_define("GDK_ISO_Partial_Space_Left")
  print print_numeric_define("GDK_ISO_Partial_Space_Right")
  print print_numeric_define("GDK_ISO_Set_Margin_Left")
  print print_numeric_define("GDK_ISO_Set_Margin_Right")
  print print_numeric_define("GDK_ISO_Release_Margin_Left")
  print print_numeric_define("GDK_ISO_Release_Margin_Right")
  print print_numeric_define("GDK_ISO_Release_Both_Margins")
  print print_numeric_define("GDK_ISO_Fast_Cursor_Left")
  print print_numeric_define("GDK_ISO_Fast_Cursor_Right")
  print print_numeric_define("GDK_ISO_Fast_Cursor_Up")
  print print_numeric_define("GDK_ISO_Fast_Cursor_Down")
  print print_numeric_define("GDK_ISO_Continuous_Underline")
  print print_numeric_define("GDK_ISO_Discontinuous_Underline")
  print print_numeric_define("GDK_ISO_Emphasize")
  print print_numeric_define("GDK_ISO_Center_Object")
  print print_numeric_define("GDK_ISO_Enter")
  print print_numeric_define("GDK_dead_grave")
  print print_numeric_define("GDK_dead_acute")
  print print_numeric_define("GDK_dead_circumflex")
  print print_numeric_define("GDK_dead_tilde")
  print print_numeric_define("GDK_dead_perispomeni")
  print print_numeric_define("GDK_dead_macron")
  print print_numeric_define("GDK_dead_breve")
  print print_numeric_define("GDK_dead_abovedot")
  print print_numeric_define("GDK_dead_diaeresis")
  print print_numeric_define("GDK_dead_abovering")
  print print_numeric_define("GDK_dead_doubleacute")
  print print_numeric_define("GDK_dead_caron")
  print print_numeric_define("GDK_dead_cedilla")
  print print_numeric_define("GDK_dead_ogonek")
  print print_numeric_define("GDK_dead_iota")
  print print_numeric_define("GDK_dead_voiced_sound")
  print print_numeric_define("GDK_dead_semivoiced_sound")
  print print_numeric_define("GDK_dead_belowdot")
  print print_numeric_define("GDK_dead_hook")
  print print_numeric_define("GDK_dead_horn")
  print print_numeric_define("GDK_dead_stroke")
  print print_numeric_define("GDK_dead_abovecomma")
  print print_numeric_define("GDK_dead_psili")
  print print_numeric_define("GDK_dead_abovereversedcomma")
  print print_numeric_define("GDK_dead_dasia")
  print print_numeric_define("GDK_dead_doublegrave")
  print print_numeric_define("GDK_dead_belowring")
  print print_numeric_define("GDK_dead_belowmacron")
  print print_numeric_define("GDK_dead_belowcircumflex")
  print print_numeric_define("GDK_dead_belowtilde")
  print print_numeric_define("GDK_dead_belowbreve")
  print print_numeric_define("GDK_dead_belowdiaeresis")
  print print_numeric_define("GDK_dead_invertedbreve")
  print print_numeric_define("GDK_dead_belowcomma")
  print print_numeric_define("GDK_dead_currency")
  print print_numeric_define("GDK_dead_a")
  print print_numeric_define("GDK_dead_A")
  print print_numeric_define("GDK_dead_e")
  print print_numeric_define("GDK_dead_E")
  print print_numeric_define("GDK_dead_i")
  print print_numeric_define("GDK_dead_I")
  print print_numeric_define("GDK_dead_o")
  print print_numeric_define("GDK_dead_O")
  print print_numeric_define("GDK_dead_u")
  print print_numeric_define("GDK_dead_U")
  print print_numeric_define("GDK_dead_small_schwa")
  print print_numeric_define("GDK_dead_capital_schwa")
  print print_numeric_define("GDK_First_Virtual_Screen")
  print print_numeric_define("GDK_Prev_Virtual_Screen")
  print print_numeric_define("GDK_Next_Virtual_Screen")
  print print_numeric_define("GDK_Last_Virtual_Screen")
  print print_numeric_define("GDK_Terminate_Server")
  print print_numeric_define("GDK_AccessX_Enable")
  print print_numeric_define("GDK_AccessX_Feedback_Enable")
  print print_numeric_define("GDK_RepeatKeys_Enable")
  print print_numeric_define("GDK_SlowKeys_Enable")
  print print_numeric_define("GDK_BounceKeys_Enable")
  print print_numeric_define("GDK_StickyKeys_Enable")
  print print_numeric_define("GDK_MouseKeys_Enable")
  print print_numeric_define("GDK_MouseKeys_Accel_Enable")
  print print_numeric_define("GDK_Overlay1_Enable")
  print print_numeric_define("GDK_Overlay2_Enable")
  print print_numeric_define("GDK_AudibleBell_Enable")
  print print_numeric_define("GDK_Pointer_Left")
  print print_numeric_define("GDK_Pointer_Right")
  print print_numeric_define("GDK_Pointer_Up")
  print print_numeric_define("GDK_Pointer_Down")
  print print_numeric_define("GDK_Pointer_UpLeft")
  print print_numeric_define("GDK_Pointer_UpRight")
  print print_numeric_define("GDK_Pointer_DownLeft")
  print print_numeric_define("GDK_Pointer_DownRight")
  print print_numeric_define("GDK_Pointer_Button_Dflt")
  print print_numeric_define("GDK_Pointer_Button1")
  print print_numeric_define("GDK_Pointer_Button2")
  print print_numeric_define("GDK_Pointer_Button3")
  print print_numeric_define("GDK_Pointer_Button4")
  print print_numeric_define("GDK_Pointer_Button5")
  print print_numeric_define("GDK_Pointer_DblClick_Dflt")
  print print_numeric_define("GDK_Pointer_DblClick1")
  print print_numeric_define("GDK_Pointer_DblClick2")
  print print_numeric_define("GDK_Pointer_DblClick3")
  print print_numeric_define("GDK_Pointer_DblClick4")
  print print_numeric_define("GDK_Pointer_DblClick5")
  print print_numeric_define("GDK_Pointer_Drag_Dflt")
  print print_numeric_define("GDK_Pointer_Drag1")
  print print_numeric_define("GDK_Pointer_Drag2")
  print print_numeric_define("GDK_Pointer_Drag3")
  print print_numeric_define("GDK_Pointer_Drag4")
  print print_numeric_define("GDK_Pointer_Drag5")
  print print_numeric_define("GDK_Pointer_EnableKeys")
  print print_numeric_define("GDK_Pointer_Accelerate")
  print print_numeric_define("GDK_Pointer_DfltBtnNext")
  print print_numeric_define("GDK_Pointer_DfltBtnPrev")
  print print_numeric_define("GDK_3270_Duplicate")
  print print_numeric_define("GDK_3270_FieldMark")
  print print_numeric_define("GDK_3270_Right2")
  print print_numeric_define("GDK_3270_Left2")
  print print_numeric_define("GDK_3270_BackTab")
  print print_numeric_define("GDK_3270_EraseEOF")
  print print_numeric_define("GDK_3270_EraseInput")
  print print_numeric_define("GDK_3270_Reset")
  print print_numeric_define("GDK_3270_Quit")
  print print_numeric_define("GDK_3270_PA1")
  print print_numeric_define("GDK_3270_PA2")
  print print_numeric_define("GDK_3270_PA3")
  print print_numeric_define("GDK_3270_Test")
  print print_numeric_define("GDK_3270_Attn")
  print print_numeric_define("GDK_3270_CursorBlink")
  print print_numeric_define("GDK_3270_AltCursor")
  print print_numeric_define("GDK_3270_KeyClick")
  print print_numeric_define("GDK_3270_Jump")
  print print_numeric_define("GDK_3270_Ident")
  print print_numeric_define("GDK_3270_Rule")
  print print_numeric_define("GDK_3270_Copy")
  print print_numeric_define("GDK_3270_Play")
  print print_numeric_define("GDK_3270_Setup")
  print print_numeric_define("GDK_3270_Record")
  print print_numeric_define("GDK_3270_ChangeScreen")
  print print_numeric_define("GDK_3270_DeleteWord")
  print print_numeric_define("GDK_3270_ExSelect")
  print print_numeric_define("GDK_3270_CursorSelect")
  print print_numeric_define("GDK_3270_PrintScreen")
  print print_numeric_define("GDK_3270_Enter")
  print print_numeric_define("GDK_space")
  print print_numeric_define("GDK_exclam")
  print print_numeric_define("GDK_quotedbl")
  print print_numeric_define("GDK_numbersign")
  print print_numeric_define("GDK_dollar")
  print print_numeric_define("GDK_percent")
  print print_numeric_define("GDK_ampersand")
  print print_numeric_define("GDK_apostrophe")
  print print_numeric_define("GDK_quoteright")
  print print_numeric_define("GDK_parenleft")
  print print_numeric_define("GDK_parenright")
  print print_numeric_define("GDK_asterisk")
  print print_numeric_define("GDK_plus")
  print print_numeric_define("GDK_comma")
  print print_numeric_define("GDK_minus")
  print print_numeric_define("GDK_period")
  print print_numeric_define("GDK_slash")
  print print_numeric_define("GDK_0")
  print print_numeric_define("GDK_1")
  print print_numeric_define("GDK_2")
  print print_numeric_define("GDK_3")
  print print_numeric_define("GDK_4")
  print print_numeric_define("GDK_5")
  print print_numeric_define("GDK_6")
  print print_numeric_define("GDK_7")
  print print_numeric_define("GDK_8")
  print print_numeric_define("GDK_9")
  print print_numeric_define("GDK_colon")
  print print_numeric_define("GDK_semicolon")
  print print_numeric_define("GDK_less")
  print print_numeric_define("GDK_equal")
  print print_numeric_define("GDK_greater")
  print print_numeric_define("GDK_question")
  print print_numeric_define("GDK_at")
  print print_numeric_define("GDK_A")
  print print_numeric_define("GDK_B")
  print print_numeric_define("GDK_C")
  print print_numeric_define("GDK_D")
  print print_numeric_define("GDK_E")
  print print_numeric_define("GDK_F")
  print print_numeric_define("GDK_G")
  print print_numeric_define("GDK_H")
  print print_numeric_define("GDK_I")
  print print_numeric_define("GDK_J")
  print print_numeric_define("GDK_K")
  print print_numeric_define("GDK_L")
  print print_numeric_define("GDK_M")
  print print_numeric_define("GDK_N")
  print print_numeric_define("GDK_O")
  print print_numeric_define("GDK_P")
  print print_numeric_define("GDK_Q")
  print print_numeric_define("GDK_R")
  print print_numeric_define("GDK_S")
  print print_numeric_define("GDK_T")
  print print_numeric_define("GDK_U")
  print print_numeric_define("GDK_V")
  print print_numeric_define("GDK_W")
  print print_numeric_define("GDK_X")
  print print_numeric_define("GDK_Y")
  print print_numeric_define("GDK_Z")
  print print_numeric_define("GDK_bracketleft")
  print print_numeric_define("GDK_backslash")
  print print_numeric_define("GDK_bracketright")
  print print_numeric_define("GDK_asciicircum")
  print print_numeric_define("GDK_underscore")
  print print_numeric_define("GDK_grave")
  print print_numeric_define("GDK_quoteleft")
  print print_numeric_define("GDK_a")
  print print_numeric_define("GDK_b")
  print print_numeric_define("GDK_c")
  print print_numeric_define("GDK_d")
  print print_numeric_define("GDK_e")
  print print_numeric_define("GDK_f")
  print print_numeric_define("GDK_g")
  print print_numeric_define("GDK_h")
  print print_numeric_define("GDK_i")
  print print_numeric_define("GDK_j")
  print print_numeric_define("GDK_k")
  print print_numeric_define("GDK_l")
  print print_numeric_define("GDK_m")
  print print_numeric_define("GDK_n")
  print print_numeric_define("GDK_o")
  print print_numeric_define("GDK_p")
  print print_numeric_define("GDK_q")
  print print_numeric_define("GDK_r")
  print print_numeric_define("GDK_s")
  print print_numeric_define("GDK_t")
  print print_numeric_define("GDK_u")
  print print_numeric_define("GDK_v")
  print print_numeric_define("GDK_w")
  print print_numeric_define("GDK_x")
  print print_numeric_define("GDK_y")
  print print_numeric_define("GDK_z")
  print print_numeric_define("GDK_braceleft")
  print print_numeric_define("GDK_bar")
  print print_numeric_define("GDK_braceright")
  print print_numeric_define("GDK_asciitilde")
  print print_numeric_define("GDK_nobreakspace")
  print print_numeric_define("GDK_exclamdown")
  print print_numeric_define("GDK_cent")
  print print_numeric_define("GDK_sterling")
  print print_numeric_define("GDK_currency")
  print print_numeric_define("GDK_yen")
  print print_numeric_define("GDK_brokenbar")
  print print_numeric_define("GDK_section")
  print print_numeric_define("GDK_diaeresis")
  print print_numeric_define("GDK_copyright")
  print print_numeric_define("GDK_ordfeminine")
  print print_numeric_define("GDK_guillemotleft")
  print print_numeric_define("GDK_notsign")
  print print_numeric_define("GDK_hyphen")
  print print_numeric_define("GDK_registered")
  print print_numeric_define("GDK_macron")
  print print_numeric_define("GDK_degree")
  print print_numeric_define("GDK_plusminus")
  print print_numeric_define("GDK_twosuperior")
  print print_numeric_define("GDK_threesuperior")
  print print_numeric_define("GDK_acute")
  print print_numeric_define("GDK_mu")
  print print_numeric_define("GDK_paragraph")
  print print_numeric_define("GDK_periodcentered")
  print print_numeric_define("GDK_cedilla")
  print print_numeric_define("GDK_onesuperior")
  print print_numeric_define("GDK_masculine")
  print print_numeric_define("GDK_guillemotright")
  print print_numeric_define("GDK_onequarter")
  print print_numeric_define("GDK_onehalf")
  print print_numeric_define("GDK_threequarters")
  print print_numeric_define("GDK_questiondown")
  print print_numeric_define("GDK_Agrave")
  print print_numeric_define("GDK_Aacute")
  print print_numeric_define("GDK_Acircumflex")
  print print_numeric_define("GDK_Atilde")
  print print_numeric_define("GDK_Adiaeresis")
  print print_numeric_define("GDK_Aring")
  print print_numeric_define("GDK_AE")
  print print_numeric_define("GDK_Ccedilla")
  print print_numeric_define("GDK_Egrave")
  print print_numeric_define("GDK_Eacute")
  print print_numeric_define("GDK_Ecircumflex")
  print print_numeric_define("GDK_Ediaeresis")
  print print_numeric_define("GDK_Igrave")
  print print_numeric_define("GDK_Iacute")
  print print_numeric_define("GDK_Icircumflex")
  print print_numeric_define("GDK_Idiaeresis")
  print print_numeric_define("GDK_ETH")
  print print_numeric_define("GDK_Eth")
  print print_numeric_define("GDK_Ntilde")
  print print_numeric_define("GDK_Ograve")
  print print_numeric_define("GDK_Oacute")
  print print_numeric_define("GDK_Ocircumflex")
  print print_numeric_define("GDK_Otilde")
  print print_numeric_define("GDK_Odiaeresis")
  print print_numeric_define("GDK_multiply")
  print print_numeric_define("GDK_Oslash")
  print print_numeric_define("GDK_Ooblique")
  print print_numeric_define("GDK_Ugrave")
  print print_numeric_define("GDK_Uacute")
  print print_numeric_define("GDK_Ucircumflex")
  print print_numeric_define("GDK_Udiaeresis")
  print print_numeric_define("GDK_Yacute")
  print print_numeric_define("GDK_THORN")
  print print_numeric_define("GDK_Thorn")
  print print_numeric_define("GDK_ssharp")
  print print_numeric_define("GDK_agrave")
  print print_numeric_define("GDK_aacute")
  print print_numeric_define("GDK_acircumflex")
  print print_numeric_define("GDK_atilde")
  print print_numeric_define("GDK_adiaeresis")
  print print_numeric_define("GDK_aring")
  print print_numeric_define("GDK_ae")
  print print_numeric_define("GDK_ccedilla")
  print print_numeric_define("GDK_egrave")
  print print_numeric_define("GDK_eacute")
  print print_numeric_define("GDK_ecircumflex")
  print print_numeric_define("GDK_ediaeresis")
  print print_numeric_define("GDK_igrave")
  print print_numeric_define("GDK_iacute")
  print print_numeric_define("GDK_icircumflex")
  print print_numeric_define("GDK_idiaeresis")
  print print_numeric_define("GDK_eth")
  print print_numeric_define("GDK_ntilde")
  print print_numeric_define("GDK_ograve")
  print print_numeric_define("GDK_oacute")
  print print_numeric_define("GDK_ocircumflex")
  print print_numeric_define("GDK_otilde")
  print print_numeric_define("GDK_odiaeresis")
  print print_numeric_define("GDK_division")
  print print_numeric_define("GDK_oslash")
  print print_numeric_define("GDK_ooblique")
  print print_numeric_define("GDK_ugrave")
  print print_numeric_define("GDK_uacute")
  print print_numeric_define("GDK_ucircumflex")
  print print_numeric_define("GDK_udiaeresis")
  print print_numeric_define("GDK_yacute")
  print print_numeric_define("GDK_thorn")
  print print_numeric_define("GDK_ydiaeresis")
  print print_numeric_define("GDK_Aogonek")
  print print_numeric_define("GDK_breve")
  print print_numeric_define("GDK_Lstroke")
  print print_numeric_define("GDK_Lcaron")
  print print_numeric_define("GDK_Sacute")
  print print_numeric_define("GDK_Scaron")
  print print_numeric_define("GDK_Scedilla")
  print print_numeric_define("GDK_Tcaron")
  print print_numeric_define("GDK_Zacute")
  print print_numeric_define("GDK_Zcaron")
  print print_numeric_define("GDK_Zabovedot")
  print print_numeric_define("GDK_aogonek")
  print print_numeric_define("GDK_ogonek")
  print print_numeric_define("GDK_lstroke")
  print print_numeric_define("GDK_lcaron")
  print print_numeric_define("GDK_sacute")
  print print_numeric_define("GDK_caron")
  print print_numeric_define("GDK_scaron")
  print print_numeric_define("GDK_scedilla")
  print print_numeric_define("GDK_tcaron")
  print print_numeric_define("GDK_zacute")
  print print_numeric_define("GDK_doubleacute")
  print print_numeric_define("GDK_zcaron")
  print print_numeric_define("GDK_zabovedot")
  print print_numeric_define("GDK_Racute")
  print print_numeric_define("GDK_Abreve")
  print print_numeric_define("GDK_Lacute")
  print print_numeric_define("GDK_Cacute")
  print print_numeric_define("GDK_Ccaron")
  print print_numeric_define("GDK_Eogonek")
  print print_numeric_define("GDK_Ecaron")
  print print_numeric_define("GDK_Dcaron")
  print print_numeric_define("GDK_Dstroke")
  print print_numeric_define("GDK_Nacute")
  print print_numeric_define("GDK_Ncaron")
  print print_numeric_define("GDK_Odoubleacute")
  print print_numeric_define("GDK_Rcaron")
  print print_numeric_define("GDK_Uring")
  print print_numeric_define("GDK_Udoubleacute")
  print print_numeric_define("GDK_Tcedilla")
  print print_numeric_define("GDK_racute")
  print print_numeric_define("GDK_abreve")
  print print_numeric_define("GDK_lacute")
  print print_numeric_define("GDK_cacute")
  print print_numeric_define("GDK_ccaron")
  print print_numeric_define("GDK_eogonek")
  print print_numeric_define("GDK_ecaron")
  print print_numeric_define("GDK_dcaron")
  print print_numeric_define("GDK_dstroke")
  print print_numeric_define("GDK_nacute")
  print print_numeric_define("GDK_ncaron")
  print print_numeric_define("GDK_odoubleacute")
  print print_numeric_define("GDK_udoubleacute")
  print print_numeric_define("GDK_rcaron")
  print print_numeric_define("GDK_uring")
  print print_numeric_define("GDK_tcedilla")
  print print_numeric_define("GDK_abovedot")
  print print_numeric_define("GDK_Hstroke")
  print print_numeric_define("GDK_Hcircumflex")
  print print_numeric_define("GDK_Iabovedot")
  print print_numeric_define("GDK_Gbreve")
  print print_numeric_define("GDK_Jcircumflex")
  print print_numeric_define("GDK_hstroke")
  print print_numeric_define("GDK_hcircumflex")
  print print_numeric_define("GDK_idotless")
  print print_numeric_define("GDK_gbreve")
  print print_numeric_define("GDK_jcircumflex")
  print print_numeric_define("GDK_Cabovedot")
  print print_numeric_define("GDK_Ccircumflex")
  print print_numeric_define("GDK_Gabovedot")
  print print_numeric_define("GDK_Gcircumflex")
  print print_numeric_define("GDK_Ubreve")
  print print_numeric_define("GDK_Scircumflex")
  print print_numeric_define("GDK_cabovedot")
  print print_numeric_define("GDK_ccircumflex")
  print print_numeric_define("GDK_gabovedot")
  print print_numeric_define("GDK_gcircumflex")
  print print_numeric_define("GDK_ubreve")
  print print_numeric_define("GDK_scircumflex")
  print print_numeric_define("GDK_kra")
  print print_numeric_define("GDK_kappa")
  print print_numeric_define("GDK_Rcedilla")
  print print_numeric_define("GDK_Itilde")
  print print_numeric_define("GDK_Lcedilla")
  print print_numeric_define("GDK_Emacron")
  print print_numeric_define("GDK_Gcedilla")
  print print_numeric_define("GDK_Tslash")
  print print_numeric_define("GDK_rcedilla")
  print print_numeric_define("GDK_itilde")
  print print_numeric_define("GDK_lcedilla")
  print print_numeric_define("GDK_emacron")
  print print_numeric_define("GDK_gcedilla")
  print print_numeric_define("GDK_tslash")
  print print_numeric_define("GDK_ENG")
  print print_numeric_define("GDK_eng")
  print print_numeric_define("GDK_Amacron")
  print print_numeric_define("GDK_Iogonek")
  print print_numeric_define("GDK_Eabovedot")
  print print_numeric_define("GDK_Imacron")
  print print_numeric_define("GDK_Ncedilla")
  print print_numeric_define("GDK_Omacron")
  print print_numeric_define("GDK_Kcedilla")
  print print_numeric_define("GDK_Uogonek")
  print print_numeric_define("GDK_Utilde")
  print print_numeric_define("GDK_Umacron")
  print print_numeric_define("GDK_amacron")
  print print_numeric_define("GDK_iogonek")
  print print_numeric_define("GDK_eabovedot")
  print print_numeric_define("GDK_imacron")
  print print_numeric_define("GDK_ncedilla")
  print print_numeric_define("GDK_omacron")
  print print_numeric_define("GDK_kcedilla")
  print print_numeric_define("GDK_uogonek")
  print print_numeric_define("GDK_utilde")
  print print_numeric_define("GDK_umacron")
  print print_numeric_define("GDK_Babovedot")
  print print_numeric_define("GDK_babovedot")
  print print_numeric_define("GDK_Dabovedot")
  print print_numeric_define("GDK_Wgrave")
  print print_numeric_define("GDK_Wacute")
  print print_numeric_define("GDK_dabovedot")
  print print_numeric_define("GDK_Ygrave")
  print print_numeric_define("GDK_Fabovedot")
  print print_numeric_define("GDK_fabovedot")
  print print_numeric_define("GDK_Mabovedot")
  print print_numeric_define("GDK_mabovedot")
  print print_numeric_define("GDK_Pabovedot")
  print print_numeric_define("GDK_wgrave")
  print print_numeric_define("GDK_pabovedot")
  print print_numeric_define("GDK_wacute")
  print print_numeric_define("GDK_Sabovedot")
  print print_numeric_define("GDK_ygrave")
  print print_numeric_define("GDK_Wdiaeresis")
  print print_numeric_define("GDK_wdiaeresis")
  print print_numeric_define("GDK_sabovedot")
  print print_numeric_define("GDK_Wcircumflex")
  print print_numeric_define("GDK_Tabovedot")
  print print_numeric_define("GDK_Ycircumflex")
  print print_numeric_define("GDK_wcircumflex")
  print print_numeric_define("GDK_tabovedot")
  print print_numeric_define("GDK_ycircumflex")
  print print_numeric_define("GDK_OE")
  print print_numeric_define("GDK_oe")
  print print_numeric_define("GDK_Ydiaeresis")
  print print_numeric_define("GDK_overline")
  print print_numeric_define("GDK_kana_fullstop")
  print print_numeric_define("GDK_kana_openingbracket")
  print print_numeric_define("GDK_kana_closingbracket")
  print print_numeric_define("GDK_kana_comma")
  print print_numeric_define("GDK_kana_conjunctive")
  print print_numeric_define("GDK_kana_middledot")
  print print_numeric_define("GDK_kana_WO")
  print print_numeric_define("GDK_kana_a")
  print print_numeric_define("GDK_kana_i")
  print print_numeric_define("GDK_kana_u")
  print print_numeric_define("GDK_kana_e")
  print print_numeric_define("GDK_kana_o")
  print print_numeric_define("GDK_kana_ya")
  print print_numeric_define("GDK_kana_yu")
  print print_numeric_define("GDK_kana_yo")
  print print_numeric_define("GDK_kana_tsu")
  print print_numeric_define("GDK_kana_tu")
  print print_numeric_define("GDK_prolongedsound")
  print print_numeric_define("GDK_kana_A")
  print print_numeric_define("GDK_kana_I")
  print print_numeric_define("GDK_kana_U")
  print print_numeric_define("GDK_kana_E")
  print print_numeric_define("GDK_kana_O")
  print print_numeric_define("GDK_kana_KA")
  print print_numeric_define("GDK_kana_KI")
  print print_numeric_define("GDK_kana_KU")
  print print_numeric_define("GDK_kana_KE")
  print print_numeric_define("GDK_kana_KO")
  print print_numeric_define("GDK_kana_SA")
  print print_numeric_define("GDK_kana_SHI")
  print print_numeric_define("GDK_kana_SU")
  print print_numeric_define("GDK_kana_SE")
  print print_numeric_define("GDK_kana_SO")
  print print_numeric_define("GDK_kana_TA")
  print print_numeric_define("GDK_kana_CHI")
  print print_numeric_define("GDK_kana_TI")
  print print_numeric_define("GDK_kana_TSU")
  print print_numeric_define("GDK_kana_TU")
  print print_numeric_define("GDK_kana_TE")
  print print_numeric_define("GDK_kana_TO")
  print print_numeric_define("GDK_kana_NA")
  print print_numeric_define("GDK_kana_NI")
  print print_numeric_define("GDK_kana_NU")
  print print_numeric_define("GDK_kana_NE")
  print print_numeric_define("GDK_kana_NO")
  print print_numeric_define("GDK_kana_HA")
  print print_numeric_define("GDK_kana_HI")
  print print_numeric_define("GDK_kana_FU")
  print print_numeric_define("GDK_kana_HU")
  print print_numeric_define("GDK_kana_HE")
  print print_numeric_define("GDK_kana_HO")
  print print_numeric_define("GDK_kana_MA")
  print print_numeric_define("GDK_kana_MI")
  print print_numeric_define("GDK_kana_MU")
  print print_numeric_define("GDK_kana_ME")
  print print_numeric_define("GDK_kana_MO")
  print print_numeric_define("GDK_kana_YA")
  print print_numeric_define("GDK_kana_YU")
  print print_numeric_define("GDK_kana_YO")
  print print_numeric_define("GDK_kana_RA")
  print print_numeric_define("GDK_kana_RI")
  print print_numeric_define("GDK_kana_RU")
  print print_numeric_define("GDK_kana_RE")
  print print_numeric_define("GDK_kana_RO")
  print print_numeric_define("GDK_kana_WA")
  print print_numeric_define("GDK_kana_N")
  print print_numeric_define("GDK_voicedsound")
  print print_numeric_define("GDK_semivoicedsound")
  print print_numeric_define("GDK_kana_switch")
  print print_numeric_define("GDK_Farsi_0")
  print print_numeric_define("GDK_Farsi_1")
  print print_numeric_define("GDK_Farsi_2")
  print print_numeric_define("GDK_Farsi_3")
  print print_numeric_define("GDK_Farsi_4")
  print print_numeric_define("GDK_Farsi_5")
  print print_numeric_define("GDK_Farsi_6")
  print print_numeric_define("GDK_Farsi_7")
  print print_numeric_define("GDK_Farsi_8")
  print print_numeric_define("GDK_Farsi_9")
  print print_numeric_define("GDK_Arabic_percent")
  print print_numeric_define("GDK_Arabic_superscript_alef")
  print print_numeric_define("GDK_Arabic_tteh")
  print print_numeric_define("GDK_Arabic_peh")
  print print_numeric_define("GDK_Arabic_tcheh")
  print print_numeric_define("GDK_Arabic_ddal")
  print print_numeric_define("GDK_Arabic_rreh")
  print print_numeric_define("GDK_Arabic_comma")
  print print_numeric_define("GDK_Arabic_fullstop")
  print print_numeric_define("GDK_Arabic_0")
  print print_numeric_define("GDK_Arabic_1")
  print print_numeric_define("GDK_Arabic_2")
  print print_numeric_define("GDK_Arabic_3")
  print print_numeric_define("GDK_Arabic_4")
  print print_numeric_define("GDK_Arabic_5")
  print print_numeric_define("GDK_Arabic_6")
  print print_numeric_define("GDK_Arabic_7")
  print print_numeric_define("GDK_Arabic_8")
  print print_numeric_define("GDK_Arabic_9")
  print print_numeric_define("GDK_Arabic_semicolon")
  print print_numeric_define("GDK_Arabic_question_mark")
  print print_numeric_define("GDK_Arabic_hamza")
  print print_numeric_define("GDK_Arabic_maddaonalef")
  print print_numeric_define("GDK_Arabic_hamzaonalef")
  print print_numeric_define("GDK_Arabic_hamzaonwaw")
  print print_numeric_define("GDK_Arabic_hamzaunderalef")
  print print_numeric_define("GDK_Arabic_hamzaonyeh")
  print print_numeric_define("GDK_Arabic_alef")
  print print_numeric_define("GDK_Arabic_beh")
  print print_numeric_define("GDK_Arabic_tehmarbuta")
  print print_numeric_define("GDK_Arabic_teh")
  print print_numeric_define("GDK_Arabic_theh")
  print print_numeric_define("GDK_Arabic_jeem")
  print print_numeric_define("GDK_Arabic_hah")
  print print_numeric_define("GDK_Arabic_khah")
  print print_numeric_define("GDK_Arabic_dal")
  print print_numeric_define("GDK_Arabic_thal")
  print print_numeric_define("GDK_Arabic_ra")
  print print_numeric_define("GDK_Arabic_zain")
  print print_numeric_define("GDK_Arabic_seen")
  print print_numeric_define("GDK_Arabic_sheen")
  print print_numeric_define("GDK_Arabic_sad")
  print print_numeric_define("GDK_Arabic_dad")
  print print_numeric_define("GDK_Arabic_tah")
  print print_numeric_define("GDK_Arabic_zah")
  print print_numeric_define("GDK_Arabic_ain")
  print print_numeric_define("GDK_Arabic_ghain")
  print print_numeric_define("GDK_Arabic_tatweel")
  print print_numeric_define("GDK_Arabic_feh")
  print print_numeric_define("GDK_Arabic_qaf")
  print print_numeric_define("GDK_Arabic_kaf")
  print print_numeric_define("GDK_Arabic_lam")
  print print_numeric_define("GDK_Arabic_meem")
  print print_numeric_define("GDK_Arabic_noon")
  print print_numeric_define("GDK_Arabic_ha")
  print print_numeric_define("GDK_Arabic_heh")
  print print_numeric_define("GDK_Arabic_waw")
  print print_numeric_define("GDK_Arabic_alefmaksura")
  print print_numeric_define("GDK_Arabic_yeh")
  print print_numeric_define("GDK_Arabic_fathatan")
  print print_numeric_define("GDK_Arabic_dammatan")
  print print_numeric_define("GDK_Arabic_kasratan")
  print print_numeric_define("GDK_Arabic_fatha")
  print print_numeric_define("GDK_Arabic_damma")
  print print_numeric_define("GDK_Arabic_kasra")
  print print_numeric_define("GDK_Arabic_shadda")
  print print_numeric_define("GDK_Arabic_sukun")
  print print_numeric_define("GDK_Arabic_madda_above")
  print print_numeric_define("GDK_Arabic_hamza_above")
  print print_numeric_define("GDK_Arabic_hamza_below")
  print print_numeric_define("GDK_Arabic_jeh")
  print print_numeric_define("GDK_Arabic_veh")
  print print_numeric_define("GDK_Arabic_keheh")
  print print_numeric_define("GDK_Arabic_gaf")
  print print_numeric_define("GDK_Arabic_noon_ghunna")
  print print_numeric_define("GDK_Arabic_heh_doachashmee")
  print print_numeric_define("GDK_Farsi_yeh")
  print print_numeric_define("GDK_Arabic_farsi_yeh")
  print print_numeric_define("GDK_Arabic_yeh_baree")
  print print_numeric_define("GDK_Arabic_heh_goal")
  print print_numeric_define("GDK_Arabic_switch")
  print print_numeric_define("GDK_Cyrillic_GHE_bar")
  print print_numeric_define("GDK_Cyrillic_ghe_bar")
  print print_numeric_define("GDK_Cyrillic_ZHE_descender")
  print print_numeric_define("GDK_Cyrillic_zhe_descender")
  print print_numeric_define("GDK_Cyrillic_KA_descender")
  print print_numeric_define("GDK_Cyrillic_ka_descender")
  print print_numeric_define("GDK_Cyrillic_KA_vertstroke")
  print print_numeric_define("GDK_Cyrillic_ka_vertstroke")
  print print_numeric_define("GDK_Cyrillic_EN_descender")
  print print_numeric_define("GDK_Cyrillic_en_descender")
  print print_numeric_define("GDK_Cyrillic_U_straight")
  print print_numeric_define("GDK_Cyrillic_u_straight")
  print print_numeric_define("GDK_Cyrillic_U_straight_bar")
  print print_numeric_define("GDK_Cyrillic_u_straight_bar")
  print print_numeric_define("GDK_Cyrillic_HA_descender")
  print print_numeric_define("GDK_Cyrillic_ha_descender")
  print print_numeric_define("GDK_Cyrillic_CHE_descender")
  print print_numeric_define("GDK_Cyrillic_che_descender")
  print print_numeric_define("GDK_Cyrillic_CHE_vertstroke")
  print print_numeric_define("GDK_Cyrillic_che_vertstroke")
  print print_numeric_define("GDK_Cyrillic_SHHA")
  print print_numeric_define("GDK_Cyrillic_shha")
  print print_numeric_define("GDK_Cyrillic_SCHWA")
  print print_numeric_define("GDK_Cyrillic_schwa")
  print print_numeric_define("GDK_Cyrillic_I_macron")
  print print_numeric_define("GDK_Cyrillic_i_macron")
  print print_numeric_define("GDK_Cyrillic_O_bar")
  print print_numeric_define("GDK_Cyrillic_o_bar")
  print print_numeric_define("GDK_Cyrillic_U_macron")
  print print_numeric_define("GDK_Cyrillic_u_macron")
  print print_numeric_define("GDK_Serbian_dje")
  print print_numeric_define("GDK_Macedonia_gje")
  print print_numeric_define("GDK_Cyrillic_io")
  print print_numeric_define("GDK_Ukrainian_ie")
  print print_numeric_define("GDK_Ukranian_je")
  print print_numeric_define("GDK_Macedonia_dse")
  print print_numeric_define("GDK_Ukrainian_i")
  print print_numeric_define("GDK_Ukranian_i")
  print print_numeric_define("GDK_Ukrainian_yi")
  print print_numeric_define("GDK_Ukranian_yi")
  print print_numeric_define("GDK_Cyrillic_je")
  print print_numeric_define("GDK_Serbian_je")
  print print_numeric_define("GDK_Cyrillic_lje")
  print print_numeric_define("GDK_Serbian_lje")
  print print_numeric_define("GDK_Cyrillic_nje")
  print print_numeric_define("GDK_Serbian_nje")
  print print_numeric_define("GDK_Serbian_tshe")
  print print_numeric_define("GDK_Macedonia_kje")
  print print_numeric_define("GDK_Ukrainian_ghe_with_upturn")
  print print_numeric_define("GDK_Byelorussian_shortu")
  print print_numeric_define("GDK_Cyrillic_dzhe")
  print print_numeric_define("GDK_Serbian_dze")
  print print_numeric_define("GDK_numerosign")
  print print_numeric_define("GDK_Serbian_DJE")
  print print_numeric_define("GDK_Macedonia_GJE")
  print print_numeric_define("GDK_Cyrillic_IO")
  print print_numeric_define("GDK_Ukrainian_IE")
  print print_numeric_define("GDK_Ukranian_JE")
  print print_numeric_define("GDK_Macedonia_DSE")
  print print_numeric_define("GDK_Ukrainian_I")
  print print_numeric_define("GDK_Ukranian_I")
  print print_numeric_define("GDK_Ukrainian_YI")
  print print_numeric_define("GDK_Ukranian_YI")
  print print_numeric_define("GDK_Cyrillic_JE")
  print print_numeric_define("GDK_Serbian_JE")
  print print_numeric_define("GDK_Cyrillic_LJE")
  print print_numeric_define("GDK_Serbian_LJE")
  print print_numeric_define("GDK_Cyrillic_NJE")
  print print_numeric_define("GDK_Serbian_NJE")
  print print_numeric_define("GDK_Serbian_TSHE")
  print print_numeric_define("GDK_Macedonia_KJE")
  print print_numeric_define("GDK_Ukrainian_GHE_WITH_UPTURN")
  print print_numeric_define("GDK_Byelorussian_SHORTU")
  print print_numeric_define("GDK_Cyrillic_DZHE")
  print print_numeric_define("GDK_Serbian_DZE")
  print print_numeric_define("GDK_Cyrillic_yu")
  print print_numeric_define("GDK_Cyrillic_a")
  print print_numeric_define("GDK_Cyrillic_be")
  print print_numeric_define("GDK_Cyrillic_tse")
  print print_numeric_define("GDK_Cyrillic_de")
  print print_numeric_define("GDK_Cyrillic_ie")
  print print_numeric_define("GDK_Cyrillic_ef")
  print print_numeric_define("GDK_Cyrillic_ghe")
  print print_numeric_define("GDK_Cyrillic_ha")
  print print_numeric_define("GDK_Cyrillic_i")
  print print_numeric_define("GDK_Cyrillic_shorti")
  print print_numeric_define("GDK_Cyrillic_ka")
  print print_numeric_define("GDK_Cyrillic_el")
  print print_numeric_define("GDK_Cyrillic_em")
  print print_numeric_define("GDK_Cyrillic_en")
  print print_numeric_define("GDK_Cyrillic_o")
  print print_numeric_define("GDK_Cyrillic_pe")
  print print_numeric_define("GDK_Cyrillic_ya")
  print print_numeric_define("GDK_Cyrillic_er")
  print print_numeric_define("GDK_Cyrillic_es")
  print print_numeric_define("GDK_Cyrillic_te")
  print print_numeric_define("GDK_Cyrillic_u")
  print print_numeric_define("GDK_Cyrillic_zhe")
  print print_numeric_define("GDK_Cyrillic_ve")
  print print_numeric_define("GDK_Cyrillic_softsign")
  print print_numeric_define("GDK_Cyrillic_yeru")
  print print_numeric_define("GDK_Cyrillic_ze")
  print print_numeric_define("GDK_Cyrillic_sha")
  print print_numeric_define("GDK_Cyrillic_e")
  print print_numeric_define("GDK_Cyrillic_shcha")
  print print_numeric_define("GDK_Cyrillic_che")
  print print_numeric_define("GDK_Cyrillic_hardsign")
  print print_numeric_define("GDK_Cyrillic_YU")
  print print_numeric_define("GDK_Cyrillic_A")
  print print_numeric_define("GDK_Cyrillic_BE")
  print print_numeric_define("GDK_Cyrillic_TSE")
  print print_numeric_define("GDK_Cyrillic_DE")
  print print_numeric_define("GDK_Cyrillic_IE")
  print print_numeric_define("GDK_Cyrillic_EF")
  print print_numeric_define("GDK_Cyrillic_GHE")
  print print_numeric_define("GDK_Cyrillic_HA")
  print print_numeric_define("GDK_Cyrillic_I")
  print print_numeric_define("GDK_Cyrillic_SHORTI")
  print print_numeric_define("GDK_Cyrillic_KA")
  print print_numeric_define("GDK_Cyrillic_EL")
  print print_numeric_define("GDK_Cyrillic_EM")
  print print_numeric_define("GDK_Cyrillic_EN")
  print print_numeric_define("GDK_Cyrillic_O")
  print print_numeric_define("GDK_Cyrillic_PE")
  print print_numeric_define("GDK_Cyrillic_YA")
  print print_numeric_define("GDK_Cyrillic_ER")
  print print_numeric_define("GDK_Cyrillic_ES")
  print print_numeric_define("GDK_Cyrillic_TE")
  print print_numeric_define("GDK_Cyrillic_U")
  print print_numeric_define("GDK_Cyrillic_ZHE")
  print print_numeric_define("GDK_Cyrillic_VE")
  print print_numeric_define("GDK_Cyrillic_SOFTSIGN")
  print print_numeric_define("GDK_Cyrillic_YERU")
  print print_numeric_define("GDK_Cyrillic_ZE")
  print print_numeric_define("GDK_Cyrillic_SHA")
  print print_numeric_define("GDK_Cyrillic_E")
  print print_numeric_define("GDK_Cyrillic_SHCHA")
  print print_numeric_define("GDK_Cyrillic_CHE")
  print print_numeric_define("GDK_Cyrillic_HARDSIGN")
  print print_numeric_define("GDK_Greek_ALPHAaccent")
  print print_numeric_define("GDK_Greek_EPSILONaccent")
  print print_numeric_define("GDK_Greek_ETAaccent")
  print print_numeric_define("GDK_Greek_IOTAaccent")
  print print_numeric_define("GDK_Greek_IOTAdieresis")
  print print_numeric_define("GDK_Greek_IOTAdiaeresis")
  print print_numeric_define("GDK_Greek_OMICRONaccent")
  print print_numeric_define("GDK_Greek_UPSILONaccent")
  print print_numeric_define("GDK_Greek_UPSILONdieresis")
  print print_numeric_define("GDK_Greek_OMEGAaccent")
  print print_numeric_define("GDK_Greek_accentdieresis")
  print print_numeric_define("GDK_Greek_horizbar")
  print print_numeric_define("GDK_Greek_alphaaccent")
  print print_numeric_define("GDK_Greek_epsilonaccent")
  print print_numeric_define("GDK_Greek_etaaccent")
  print print_numeric_define("GDK_Greek_iotaaccent")
  print print_numeric_define("GDK_Greek_iotadieresis")
  print print_numeric_define("GDK_Greek_iotaaccentdieresis")
  print print_numeric_define("GDK_Greek_omicronaccent")
  print print_numeric_define("GDK_Greek_upsilonaccent")
  print print_numeric_define("GDK_Greek_upsilondieresis")
  print print_numeric_define("GDK_Greek_upsilonaccentdieresis")
  print print_numeric_define("GDK_Greek_omegaaccent")
  print print_numeric_define("GDK_Greek_ALPHA")
  print print_numeric_define("GDK_Greek_BETA")
  print print_numeric_define("GDK_Greek_GAMMA")
  print print_numeric_define("GDK_Greek_DELTA")
  print print_numeric_define("GDK_Greek_EPSILON")
  print print_numeric_define("GDK_Greek_ZETA")
  print print_numeric_define("GDK_Greek_ETA")
  print print_numeric_define("GDK_Greek_THETA")
  print print_numeric_define("GDK_Greek_IOTA")
  print print_numeric_define("GDK_Greek_KAPPA")
  print print_numeric_define("GDK_Greek_LAMDA")
  print print_numeric_define("GDK_Greek_LAMBDA")
  print print_numeric_define("GDK_Greek_MU")
  print print_numeric_define("GDK_Greek_NU")
  print print_numeric_define("GDK_Greek_XI")
  print print_numeric_define("GDK_Greek_OMICRON")
  print print_numeric_define("GDK_Greek_PI")
  print print_numeric_define("GDK_Greek_RHO")
  print print_numeric_define("GDK_Greek_SIGMA")
  print print_numeric_define("GDK_Greek_TAU")
  print print_numeric_define("GDK_Greek_UPSILON")
  print print_numeric_define("GDK_Greek_PHI")
  print print_numeric_define("GDK_Greek_CHI")
  print print_numeric_define("GDK_Greek_PSI")
  print print_numeric_define("GDK_Greek_OMEGA")
  print print_numeric_define("GDK_Greek_alpha")
  print print_numeric_define("GDK_Greek_beta")
  print print_numeric_define("GDK_Greek_gamma")
  print print_numeric_define("GDK_Greek_delta")
  print print_numeric_define("GDK_Greek_epsilon")
  print print_numeric_define("GDK_Greek_zeta")
  print print_numeric_define("GDK_Greek_eta")
  print print_numeric_define("GDK_Greek_theta")
  print print_numeric_define("GDK_Greek_iota")
  print print_numeric_define("GDK_Greek_kappa")
  print print_numeric_define("GDK_Greek_lamda")
  print print_numeric_define("GDK_Greek_lambda")
  print print_numeric_define("GDK_Greek_mu")
  print print_numeric_define("GDK_Greek_nu")
  print print_numeric_define("GDK_Greek_xi")
  print print_numeric_define("GDK_Greek_omicron")
  print print_numeric_define("GDK_Greek_pi")
  print print_numeric_define("GDK_Greek_rho")
  print print_numeric_define("GDK_Greek_sigma")
  print print_numeric_define("GDK_Greek_finalsmallsigma")
  print print_numeric_define("GDK_Greek_tau")
  print print_numeric_define("GDK_Greek_upsilon")
  print print_numeric_define("GDK_Greek_phi")
  print print_numeric_define("GDK_Greek_chi")
  print print_numeric_define("GDK_Greek_psi")
  print print_numeric_define("GDK_Greek_omega")
  print print_numeric_define("GDK_Greek_switch")
  print print_numeric_define("GDK_leftradical")
  print print_numeric_define("GDK_topleftradical")
  print print_numeric_define("GDK_horizconnector")
  print print_numeric_define("GDK_topintegral")
  print print_numeric_define("GDK_botintegral")
  print print_numeric_define("GDK_vertconnector")
  print print_numeric_define("GDK_topleftsqbracket")
  print print_numeric_define("GDK_botleftsqbracket")
  print print_numeric_define("GDK_toprightsqbracket")
  print print_numeric_define("GDK_botrightsqbracket")
  print print_numeric_define("GDK_topleftparens")
  print print_numeric_define("GDK_botleftparens")
  print print_numeric_define("GDK_toprightparens")
  print print_numeric_define("GDK_botrightparens")
  print print_numeric_define("GDK_leftmiddlecurlybrace")
  print print_numeric_define("GDK_rightmiddlecurlybrace")
  print print_numeric_define("GDK_topleftsummation")
  print print_numeric_define("GDK_botleftsummation")
  print print_numeric_define("GDK_topvertsummationconnector")
  print print_numeric_define("GDK_botvertsummationconnector")
  print print_numeric_define("GDK_toprightsummation")
  print print_numeric_define("GDK_botrightsummation")
  print print_numeric_define("GDK_rightmiddlesummation")
  print print_numeric_define("GDK_lessthanequal")
  print print_numeric_define("GDK_notequal")
  print print_numeric_define("GDK_greaterthanequal")
  print print_numeric_define("GDK_integral")
  print print_numeric_define("GDK_therefore")
  print print_numeric_define("GDK_variation")
  print print_numeric_define("GDK_infinity")
  print print_numeric_define("GDK_nabla")
  print print_numeric_define("GDK_approximate")
  print print_numeric_define("GDK_similarequal")
  print print_numeric_define("GDK_ifonlyif")
  print print_numeric_define("GDK_implies")
  print print_numeric_define("GDK_identical")
  print print_numeric_define("GDK_radical")
  print print_numeric_define("GDK_includedin")
  print print_numeric_define("GDK_includes")
  print print_numeric_define("GDK_intersection")
  print print_numeric_define("GDK_union")
  print print_numeric_define("GDK_logicaland")
  print print_numeric_define("GDK_logicalor")
  print print_numeric_define("GDK_partialderivative")
  print print_numeric_define("GDK_function")
  print print_numeric_define("GDK_leftarrow")
  print print_numeric_define("GDK_uparrow")
  print print_numeric_define("GDK_rightarrow")
  print print_numeric_define("GDK_downarrow")
  print print_numeric_define("GDK_blank")
  print print_numeric_define("GDK_soliddiamond")
  print print_numeric_define("GDK_checkerboard")
  print print_numeric_define("GDK_ht")
  print print_numeric_define("GDK_ff")
  print print_numeric_define("GDK_cr")
  print print_numeric_define("GDK_lf")
  print print_numeric_define("GDK_nl")
  print print_numeric_define("GDK_vt")
  print print_numeric_define("GDK_lowrightcorner")
  print print_numeric_define("GDK_uprightcorner")
  print print_numeric_define("GDK_upleftcorner")
  print print_numeric_define("GDK_lowleftcorner")
  print print_numeric_define("GDK_crossinglines")
  print print_numeric_define("GDK_horizlinescan1")
  print print_numeric_define("GDK_horizlinescan3")
  print print_numeric_define("GDK_horizlinescan5")
  print print_numeric_define("GDK_horizlinescan7")
  print print_numeric_define("GDK_horizlinescan9")
  print print_numeric_define("GDK_leftt")
  print print_numeric_define("GDK_rightt")
  print print_numeric_define("GDK_bott")
  print print_numeric_define("GDK_topt")
  print print_numeric_define("GDK_vertbar")
  print print_numeric_define("GDK_emspace")
  print print_numeric_define("GDK_enspace")
  print print_numeric_define("GDK_em3space")
  print print_numeric_define("GDK_em4space")
  print print_numeric_define("GDK_digitspace")
  print print_numeric_define("GDK_punctspace")
  print print_numeric_define("GDK_thinspace")
  print print_numeric_define("GDK_hairspace")
  print print_numeric_define("GDK_emdash")
  print print_numeric_define("GDK_endash")
  print print_numeric_define("GDK_signifblank")
  print print_numeric_define("GDK_ellipsis")
  print print_numeric_define("GDK_doubbaselinedot")
  print print_numeric_define("GDK_onethird")
  print print_numeric_define("GDK_twothirds")
  print print_numeric_define("GDK_onefifth")
  print print_numeric_define("GDK_twofifths")
  print print_numeric_define("GDK_threefifths")
  print print_numeric_define("GDK_fourfifths")
  print print_numeric_define("GDK_onesixth")
  print print_numeric_define("GDK_fivesixths")
  print print_numeric_define("GDK_careof")
  print print_numeric_define("GDK_figdash")
  print print_numeric_define("GDK_leftanglebracket")
  print print_numeric_define("GDK_decimalpoint")
  print print_numeric_define("GDK_rightanglebracket")
  print print_numeric_define("GDK_marker")
  print print_numeric_define("GDK_oneeighth")
  print print_numeric_define("GDK_threeeighths")
  print print_numeric_define("GDK_fiveeighths")
  print print_numeric_define("GDK_seveneighths")
  print print_numeric_define("GDK_trademark")
  print print_numeric_define("GDK_signaturemark")
  print print_numeric_define("GDK_trademarkincircle")
  print print_numeric_define("GDK_leftopentriangle")
  print print_numeric_define("GDK_rightopentriangle")
  print print_numeric_define("GDK_emopencircle")
  print print_numeric_define("GDK_emopenrectangle")
  print print_numeric_define("GDK_leftsinglequotemark")
  print print_numeric_define("GDK_rightsinglequotemark")
  print print_numeric_define("GDK_leftdoublequotemark")
  print print_numeric_define("GDK_rightdoublequotemark")
  print print_numeric_define("GDK_prescription")
  print print_numeric_define("GDK_minutes")
  print print_numeric_define("GDK_seconds")
  print print_numeric_define("GDK_latincross")
  print print_numeric_define("GDK_hexagram")
  print print_numeric_define("GDK_filledrectbullet")
  print print_numeric_define("GDK_filledlefttribullet")
  print print_numeric_define("GDK_filledrighttribullet")
  print print_numeric_define("GDK_emfilledcircle")
  print print_numeric_define("GDK_emfilledrect")
  print print_numeric_define("GDK_enopencircbullet")
  print print_numeric_define("GDK_enopensquarebullet")
  print print_numeric_define("GDK_openrectbullet")
  print print_numeric_define("GDK_opentribulletup")
  print print_numeric_define("GDK_opentribulletdown")
  print print_numeric_define("GDK_openstar")
  print print_numeric_define("GDK_enfilledcircbullet")
  print print_numeric_define("GDK_enfilledsqbullet")
  print print_numeric_define("GDK_filledtribulletup")
  print print_numeric_define("GDK_filledtribulletdown")
  print print_numeric_define("GDK_leftpointer")
  print print_numeric_define("GDK_rightpointer")
  print print_numeric_define("GDK_club")
  print print_numeric_define("GDK_diamond")
  print print_numeric_define("GDK_heart")
  print print_numeric_define("GDK_maltesecross")
  print print_numeric_define("GDK_dagger")
  print print_numeric_define("GDK_doubledagger")
  print print_numeric_define("GDK_checkmark")
  print print_numeric_define("GDK_ballotcross")
  print print_numeric_define("GDK_musicalsharp")
  print print_numeric_define("GDK_musicalflat")
  print print_numeric_define("GDK_malesymbol")
  print print_numeric_define("GDK_femalesymbol")
  print print_numeric_define("GDK_telephone")
  print print_numeric_define("GDK_telephonerecorder")
  print print_numeric_define("GDK_phonographcopyright")
  print print_numeric_define("GDK_caret")
  print print_numeric_define("GDK_singlelowquotemark")
  print print_numeric_define("GDK_doublelowquotemark")
  print print_numeric_define("GDK_cursor")
  print print_numeric_define("GDK_leftcaret")
  print print_numeric_define("GDK_rightcaret")
  print print_numeric_define("GDK_downcaret")
  print print_numeric_define("GDK_upcaret")
  print print_numeric_define("GDK_overbar")
  print print_numeric_define("GDK_downtack")
  print print_numeric_define("GDK_upshoe")
  print print_numeric_define("GDK_downstile")
  print print_numeric_define("GDK_underbar")
  print print_numeric_define("GDK_jot")
  print print_numeric_define("GDK_quad")
  print print_numeric_define("GDK_uptack")
  print print_numeric_define("GDK_circle")
  print print_numeric_define("GDK_upstile")
  print print_numeric_define("GDK_downshoe")
  print print_numeric_define("GDK_rightshoe")
  print print_numeric_define("GDK_leftshoe")
  print print_numeric_define("GDK_lefttack")
  print print_numeric_define("GDK_righttack")
  print print_numeric_define("GDK_hebrew_doublelowline")
  print print_numeric_define("GDK_hebrew_aleph")
  print print_numeric_define("GDK_hebrew_bet")
  print print_numeric_define("GDK_hebrew_beth")
  print print_numeric_define("GDK_hebrew_gimel")
  print print_numeric_define("GDK_hebrew_gimmel")
  print print_numeric_define("GDK_hebrew_dalet")
  print print_numeric_define("GDK_hebrew_daleth")
  print print_numeric_define("GDK_hebrew_he")
  print print_numeric_define("GDK_hebrew_waw")
  print print_numeric_define("GDK_hebrew_zain")
  print print_numeric_define("GDK_hebrew_zayin")
  print print_numeric_define("GDK_hebrew_chet")
  print print_numeric_define("GDK_hebrew_het")
  print print_numeric_define("GDK_hebrew_tet")
  print print_numeric_define("GDK_hebrew_teth")
  print print_numeric_define("GDK_hebrew_yod")
  print print_numeric_define("GDK_hebrew_finalkaph")
  print print_numeric_define("GDK_hebrew_kaph")
  print print_numeric_define("GDK_hebrew_lamed")
  print print_numeric_define("GDK_hebrew_finalmem")
  print print_numeric_define("GDK_hebrew_mem")
  print print_numeric_define("GDK_hebrew_finalnun")
  print print_numeric_define("GDK_hebrew_nun")
  print print_numeric_define("GDK_hebrew_samech")
  print print_numeric_define("GDK_hebrew_samekh")
  print print_numeric_define("GDK_hebrew_ayin")
  print print_numeric_define("GDK_hebrew_finalpe")
  print print_numeric_define("GDK_hebrew_pe")
  print print_numeric_define("GDK_hebrew_finalzade")
  print print_numeric_define("GDK_hebrew_finalzadi")
  print print_numeric_define("GDK_hebrew_zade")
  print print_numeric_define("GDK_hebrew_zadi")
  print print_numeric_define("GDK_hebrew_qoph")
  print print_numeric_define("GDK_hebrew_kuf")
  print print_numeric_define("GDK_hebrew_resh")
  print print_numeric_define("GDK_hebrew_shin")
  print print_numeric_define("GDK_hebrew_taw")
  print print_numeric_define("GDK_hebrew_taf")
  print print_numeric_define("GDK_Hebrew_switch")
  print print_numeric_define("GDK_Thai_kokai")
  print print_numeric_define("GDK_Thai_khokhai")
  print print_numeric_define("GDK_Thai_khokhuat")
  print print_numeric_define("GDK_Thai_khokhwai")
  print print_numeric_define("GDK_Thai_khokhon")
  print print_numeric_define("GDK_Thai_khorakhang")
  print print_numeric_define("GDK_Thai_ngongu")
  print print_numeric_define("GDK_Thai_chochan")
  print print_numeric_define("GDK_Thai_choching")
  print print_numeric_define("GDK_Thai_chochang")
  print print_numeric_define("GDK_Thai_soso")
  print print_numeric_define("GDK_Thai_chochoe")
  print print_numeric_define("GDK_Thai_yoying")
  print print_numeric_define("GDK_Thai_dochada")
  print print_numeric_define("GDK_Thai_topatak")
  print print_numeric_define("GDK_Thai_thothan")
  print print_numeric_define("GDK_Thai_thonangmontho")
  print print_numeric_define("GDK_Thai_thophuthao")
  print print_numeric_define("GDK_Thai_nonen")
  print print_numeric_define("GDK_Thai_dodek")
  print print_numeric_define("GDK_Thai_totao")
  print print_numeric_define("GDK_Thai_thothung")
  print print_numeric_define("GDK_Thai_thothahan")
  print print_numeric_define("GDK_Thai_thothong")
  print print_numeric_define("GDK_Thai_nonu")
  print print_numeric_define("GDK_Thai_bobaimai")
  print print_numeric_define("GDK_Thai_popla")
  print print_numeric_define("GDK_Thai_phophung")
  print print_numeric_define("GDK_Thai_fofa")
  print print_numeric_define("GDK_Thai_phophan")
  print print_numeric_define("GDK_Thai_fofan")
  print print_numeric_define("GDK_Thai_phosamphao")
  print print_numeric_define("GDK_Thai_moma")
  print print_numeric_define("GDK_Thai_yoyak")
  print print_numeric_define("GDK_Thai_rorua")
  print print_numeric_define("GDK_Thai_ru")
  print print_numeric_define("GDK_Thai_loling")
  print print_numeric_define("GDK_Thai_lu")
  print print_numeric_define("GDK_Thai_wowaen")
  print print_numeric_define("GDK_Thai_sosala")
  print print_numeric_define("GDK_Thai_sorusi")
  print print_numeric_define("GDK_Thai_sosua")
  print print_numeric_define("GDK_Thai_hohip")
  print print_numeric_define("GDK_Thai_lochula")
  print print_numeric_define("GDK_Thai_oang")
  print print_numeric_define("GDK_Thai_honokhuk")
  print print_numeric_define("GDK_Thai_paiyannoi")
  print print_numeric_define("GDK_Thai_saraa")
  print print_numeric_define("GDK_Thai_maihanakat")
  print print_numeric_define("GDK_Thai_saraaa")
  print print_numeric_define("GDK_Thai_saraam")
  print print_numeric_define("GDK_Thai_sarai")
  print print_numeric_define("GDK_Thai_saraii")
  print print_numeric_define("GDK_Thai_saraue")
  print print_numeric_define("GDK_Thai_sarauee")
  print print_numeric_define("GDK_Thai_sarau")
  print print_numeric_define("GDK_Thai_sarauu")
  print print_numeric_define("GDK_Thai_phinthu")
  print print_numeric_define("GDK_Thai_maihanakat_maitho")
  print print_numeric_define("GDK_Thai_baht")
  print print_numeric_define("GDK_Thai_sarae")
  print print_numeric_define("GDK_Thai_saraae")
  print print_numeric_define("GDK_Thai_sarao")
  print print_numeric_define("GDK_Thai_saraaimaimuan")
  print print_numeric_define("GDK_Thai_saraaimaimalai")
  print print_numeric_define("GDK_Thai_lakkhangyao")
  print print_numeric_define("GDK_Thai_maiyamok")
  print print_numeric_define("GDK_Thai_maitaikhu")
  print print_numeric_define("GDK_Thai_maiek")
  print print_numeric_define("GDK_Thai_maitho")
  print print_numeric_define("GDK_Thai_maitri")
  print print_numeric_define("GDK_Thai_maichattawa")
  print print_numeric_define("GDK_Thai_thanthakhat")
  print print_numeric_define("GDK_Thai_nikhahit")
  print print_numeric_define("GDK_Thai_leksun")
  print print_numeric_define("GDK_Thai_leknung")
  print print_numeric_define("GDK_Thai_leksong")
  print print_numeric_define("GDK_Thai_leksam")
  print print_numeric_define("GDK_Thai_leksi")
  print print_numeric_define("GDK_Thai_lekha")
  print print_numeric_define("GDK_Thai_lekhok")
  print print_numeric_define("GDK_Thai_lekchet")
  print print_numeric_define("GDK_Thai_lekpaet")
  print print_numeric_define("GDK_Thai_lekkao")
  print print_numeric_define("GDK_Hangul")
  print print_numeric_define("GDK_Hangul_Start")
  print print_numeric_define("GDK_Hangul_End")
  print print_numeric_define("GDK_Hangul_Hanja")
  print print_numeric_define("GDK_Hangul_Jamo")
  print print_numeric_define("GDK_Hangul_Romaja")
  print print_numeric_define("GDK_Hangul_Codeinput")
  print print_numeric_define("GDK_Hangul_Jeonja")
  print print_numeric_define("GDK_Hangul_Banja")
  print print_numeric_define("GDK_Hangul_PreHanja")
  print print_numeric_define("GDK_Hangul_PostHanja")
  print print_numeric_define("GDK_Hangul_SingleCandidate")
  print print_numeric_define("GDK_Hangul_MultipleCandidate")
  print print_numeric_define("GDK_Hangul_PreviousCandidate")
  print print_numeric_define("GDK_Hangul_Special")
  print print_numeric_define("GDK_Hangul_switch")
  print print_numeric_define("GDK_Hangul_Kiyeog")
  print print_numeric_define("GDK_Hangul_SsangKiyeog")
  print print_numeric_define("GDK_Hangul_KiyeogSios")
  print print_numeric_define("GDK_Hangul_Nieun")
  print print_numeric_define("GDK_Hangul_NieunJieuj")
  print print_numeric_define("GDK_Hangul_NieunHieuh")
  print print_numeric_define("GDK_Hangul_Dikeud")
  print print_numeric_define("GDK_Hangul_SsangDikeud")
  print print_numeric_define("GDK_Hangul_Rieul")
  print print_numeric_define("GDK_Hangul_RieulKiyeog")
  print print_numeric_define("GDK_Hangul_RieulMieum")
  print print_numeric_define("GDK_Hangul_RieulPieub")
  print print_numeric_define("GDK_Hangul_RieulSios")
  print print_numeric_define("GDK_Hangul_RieulTieut")
  print print_numeric_define("GDK_Hangul_RieulPhieuf")
  print print_numeric_define("GDK_Hangul_RieulHieuh")
  print print_numeric_define("GDK_Hangul_Mieum")
  print print_numeric_define("GDK_Hangul_Pieub")
  print print_numeric_define("GDK_Hangul_SsangPieub")
  print print_numeric_define("GDK_Hangul_PieubSios")
  print print_numeric_define("GDK_Hangul_Sios")
  print print_numeric_define("GDK_Hangul_SsangSios")
  print print_numeric_define("GDK_Hangul_Ieung")
  print print_numeric_define("GDK_Hangul_Jieuj")
  print print_numeric_define("GDK_Hangul_SsangJieuj")
  print print_numeric_define("GDK_Hangul_Cieuc")
  print print_numeric_define("GDK_Hangul_Khieuq")
  print print_numeric_define("GDK_Hangul_Tieut")
  print print_numeric_define("GDK_Hangul_Phieuf")
  print print_numeric_define("GDK_Hangul_Hieuh")
  print print_numeric_define("GDK_Hangul_A")
  print print_numeric_define("GDK_Hangul_AE")
  print print_numeric_define("GDK_Hangul_YA")
  print print_numeric_define("GDK_Hangul_YAE")
  print print_numeric_define("GDK_Hangul_EO")
  print print_numeric_define("GDK_Hangul_E")
  print print_numeric_define("GDK_Hangul_YEO")
  print print_numeric_define("GDK_Hangul_YE")
  print print_numeric_define("GDK_Hangul_O")
  print print_numeric_define("GDK_Hangul_WA")
  print print_numeric_define("GDK_Hangul_WAE")
  print print_numeric_define("GDK_Hangul_OE")
  print print_numeric_define("GDK_Hangul_YO")
  print print_numeric_define("GDK_Hangul_U")
  print print_numeric_define("GDK_Hangul_WEO")
  print print_numeric_define("GDK_Hangul_WE")
  print print_numeric_define("GDK_Hangul_WI")
  print print_numeric_define("GDK_Hangul_YU")
  print print_numeric_define("GDK_Hangul_EU")
  print print_numeric_define("GDK_Hangul_YI")
  print print_numeric_define("GDK_Hangul_I")
  print print_numeric_define("GDK_Hangul_J_Kiyeog")
  print print_numeric_define("GDK_Hangul_J_SsangKiyeog")
  print print_numeric_define("GDK_Hangul_J_KiyeogSios")
  print print_numeric_define("GDK_Hangul_J_Nieun")
  print print_numeric_define("GDK_Hangul_J_NieunJieuj")
  print print_numeric_define("GDK_Hangul_J_NieunHieuh")
  print print_numeric_define("GDK_Hangul_J_Dikeud")
  print print_numeric_define("GDK_Hangul_J_Rieul")
  print print_numeric_define("GDK_Hangul_J_RieulKiyeog")
  print print_numeric_define("GDK_Hangul_J_RieulMieum")
  print print_numeric_define("GDK_Hangul_J_RieulPieub")
  print print_numeric_define("GDK_Hangul_J_RieulSios")
  print print_numeric_define("GDK_Hangul_J_RieulTieut")
  print print_numeric_define("GDK_Hangul_J_RieulPhieuf")
  print print_numeric_define("GDK_Hangul_J_RieulHieuh")
  print print_numeric_define("GDK_Hangul_J_Mieum")
  print print_numeric_define("GDK_Hangul_J_Pieub")
  print print_numeric_define("GDK_Hangul_J_PieubSios")
  print print_numeric_define("GDK_Hangul_J_Sios")
  print print_numeric_define("GDK_Hangul_J_SsangSios")
  print print_numeric_define("GDK_Hangul_J_Ieung")
  print print_numeric_define("GDK_Hangul_J_Jieuj")
  print print_numeric_define("GDK_Hangul_J_Cieuc")
  print print_numeric_define("GDK_Hangul_J_Khieuq")
  print print_numeric_define("GDK_Hangul_J_Tieut")
  print print_numeric_define("GDK_Hangul_J_Phieuf")
  print print_numeric_define("GDK_Hangul_J_Hieuh")
  print print_numeric_define("GDK_Hangul_RieulYeorinHieuh")
  print print_numeric_define("GDK_Hangul_SunkyeongeumMieum")
  print print_numeric_define("GDK_Hangul_SunkyeongeumPieub")
  print print_numeric_define("GDK_Hangul_PanSios")
  print print_numeric_define("GDK_Hangul_KkogjiDalrinIeung")
  print print_numeric_define("GDK_Hangul_SunkyeongeumPhieuf")
  print print_numeric_define("GDK_Hangul_YeorinHieuh")
  print print_numeric_define("GDK_Hangul_AraeA")
  print print_numeric_define("GDK_Hangul_AraeAE")
  print print_numeric_define("GDK_Hangul_J_PanSios")
  print print_numeric_define("GDK_Hangul_J_KkogjiDalrinIeung")
  print print_numeric_define("GDK_Hangul_J_YeorinHieuh")
  print print_numeric_define("GDK_Korean_Won")
  print print_numeric_define("GDK_Armenian_ligature_ew")
  print print_numeric_define("GDK_Armenian_full_stop")
  print print_numeric_define("GDK_Armenian_verjaket")
  print print_numeric_define("GDK_Armenian_separation_mark")
  print print_numeric_define("GDK_Armenian_but")
  print print_numeric_define("GDK_Armenian_hyphen")
  print print_numeric_define("GDK_Armenian_yentamna")
  print print_numeric_define("GDK_Armenian_exclam")
  print print_numeric_define("GDK_Armenian_amanak")
  print print_numeric_define("GDK_Armenian_accent")
  print print_numeric_define("GDK_Armenian_shesht")
  print print_numeric_define("GDK_Armenian_question")
  print print_numeric_define("GDK_Armenian_paruyk")
  print print_numeric_define("GDK_Armenian_AYB")
  print print_numeric_define("GDK_Armenian_ayb")
  print print_numeric_define("GDK_Armenian_BEN")
  print print_numeric_define("GDK_Armenian_ben")
  print print_numeric_define("GDK_Armenian_GIM")
  print print_numeric_define("GDK_Armenian_gim")
  print print_numeric_define("GDK_Armenian_DA")
  print print_numeric_define("GDK_Armenian_da")
  print print_numeric_define("GDK_Armenian_YECH")
  print print_numeric_define("GDK_Armenian_yech")
  print print_numeric_define("GDK_Armenian_ZA")
  print print_numeric_define("GDK_Armenian_za")
  print print_numeric_define("GDK_Armenian_E")
  print print_numeric_define("GDK_Armenian_e")
  print print_numeric_define("GDK_Armenian_AT")
  print print_numeric_define("GDK_Armenian_at")
  print print_numeric_define("GDK_Armenian_TO")
  print print_numeric_define("GDK_Armenian_to")
  print print_numeric_define("GDK_Armenian_ZHE")
  print print_numeric_define("GDK_Armenian_zhe")
  print print_numeric_define("GDK_Armenian_INI")
  print print_numeric_define("GDK_Armenian_ini")
  print print_numeric_define("GDK_Armenian_LYUN")
  print print_numeric_define("GDK_Armenian_lyun")
  print print_numeric_define("GDK_Armenian_KHE")
  print print_numeric_define("GDK_Armenian_khe")
  print print_numeric_define("GDK_Armenian_TSA")
  print print_numeric_define("GDK_Armenian_tsa")
  print print_numeric_define("GDK_Armenian_KEN")
  print print_numeric_define("GDK_Armenian_ken")
  print print_numeric_define("GDK_Armenian_HO")
  print print_numeric_define("GDK_Armenian_ho")
  print print_numeric_define("GDK_Armenian_DZA")
  print print_numeric_define("GDK_Armenian_dza")
  print print_numeric_define("GDK_Armenian_GHAT")
  print print_numeric_define("GDK_Armenian_ghat")
  print print_numeric_define("GDK_Armenian_TCHE")
  print print_numeric_define("GDK_Armenian_tche")
  print print_numeric_define("GDK_Armenian_MEN")
  print print_numeric_define("GDK_Armenian_men")
  print print_numeric_define("GDK_Armenian_HI")
  print print_numeric_define("GDK_Armenian_hi")
  print print_numeric_define("GDK_Armenian_NU")
  print print_numeric_define("GDK_Armenian_nu")
  print print_numeric_define("GDK_Armenian_SHA")
  print print_numeric_define("GDK_Armenian_sha")
  print print_numeric_define("GDK_Armenian_VO")
  print print_numeric_define("GDK_Armenian_vo")
  print print_numeric_define("GDK_Armenian_CHA")
  print print_numeric_define("GDK_Armenian_cha")
  print print_numeric_define("GDK_Armenian_PE")
  print print_numeric_define("GDK_Armenian_pe")
  print print_numeric_define("GDK_Armenian_JE")
  print print_numeric_define("GDK_Armenian_je")
  print print_numeric_define("GDK_Armenian_RA")
  print print_numeric_define("GDK_Armenian_ra")
  print print_numeric_define("GDK_Armenian_SE")
  print print_numeric_define("GDK_Armenian_se")
  print print_numeric_define("GDK_Armenian_VEV")
  print print_numeric_define("GDK_Armenian_vev")
  print print_numeric_define("GDK_Armenian_TYUN")
  print print_numeric_define("GDK_Armenian_tyun")
  print print_numeric_define("GDK_Armenian_RE")
  print print_numeric_define("GDK_Armenian_re")
  print print_numeric_define("GDK_Armenian_TSO")
  print print_numeric_define("GDK_Armenian_tso")
  print print_numeric_define("GDK_Armenian_VYUN")
  print print_numeric_define("GDK_Armenian_vyun")
  print print_numeric_define("GDK_Armenian_PYUR")
  print print_numeric_define("GDK_Armenian_pyur")
  print print_numeric_define("GDK_Armenian_KE")
  print print_numeric_define("GDK_Armenian_ke")
  print print_numeric_define("GDK_Armenian_O")
  print print_numeric_define("GDK_Armenian_o")
  print print_numeric_define("GDK_Armenian_FE")
  print print_numeric_define("GDK_Armenian_fe")
  print print_numeric_define("GDK_Armenian_apostrophe")
  print print_numeric_define("GDK_Georgian_an")
  print print_numeric_define("GDK_Georgian_ban")
  print print_numeric_define("GDK_Georgian_gan")
  print print_numeric_define("GDK_Georgian_don")
  print print_numeric_define("GDK_Georgian_en")
  print print_numeric_define("GDK_Georgian_vin")
  print print_numeric_define("GDK_Georgian_zen")
  print print_numeric_define("GDK_Georgian_tan")
  print print_numeric_define("GDK_Georgian_in")
  print print_numeric_define("GDK_Georgian_kan")
  print print_numeric_define("GDK_Georgian_las")
  print print_numeric_define("GDK_Georgian_man")
  print print_numeric_define("GDK_Georgian_nar")
  print print_numeric_define("GDK_Georgian_on")
  print print_numeric_define("GDK_Georgian_par")
  print print_numeric_define("GDK_Georgian_zhar")
  print print_numeric_define("GDK_Georgian_rae")
  print print_numeric_define("GDK_Georgian_san")
  print print_numeric_define("GDK_Georgian_tar")
  print print_numeric_define("GDK_Georgian_un")
  print print_numeric_define("GDK_Georgian_phar")
  print print_numeric_define("GDK_Georgian_khar")
  print print_numeric_define("GDK_Georgian_ghan")
  print print_numeric_define("GDK_Georgian_qar")
  print print_numeric_define("GDK_Georgian_shin")
  print print_numeric_define("GDK_Georgian_chin")
  print print_numeric_define("GDK_Georgian_can")
  print print_numeric_define("GDK_Georgian_jil")
  print print_numeric_define("GDK_Georgian_cil")
  print print_numeric_define("GDK_Georgian_char")
  print print_numeric_define("GDK_Georgian_xan")
  print print_numeric_define("GDK_Georgian_jhan")
  print print_numeric_define("GDK_Georgian_hae")
  print print_numeric_define("GDK_Georgian_he")
  print print_numeric_define("GDK_Georgian_hie")
  print print_numeric_define("GDK_Georgian_we")
  print print_numeric_define("GDK_Georgian_har")
  print print_numeric_define("GDK_Georgian_hoe")
  print print_numeric_define("GDK_Georgian_fi")
  print print_numeric_define("GDK_Xabovedot")
  print print_numeric_define("GDK_Ibreve")
  print print_numeric_define("GDK_Zstroke")
  print print_numeric_define("GDK_Gcaron")
  print print_numeric_define("GDK_Ocaron")
  print print_numeric_define("GDK_Obarred")
  print print_numeric_define("GDK_xabovedot")
  print print_numeric_define("GDK_ibreve")
  print print_numeric_define("GDK_zstroke")
  print print_numeric_define("GDK_gcaron")
  print print_numeric_define("GDK_ocaron")
  print print_numeric_define("GDK_obarred")
  print print_numeric_define("GDK_SCHWA")
  print print_numeric_define("GDK_schwa")
  print print_numeric_define("GDK_Lbelowdot")
  print print_numeric_define("GDK_lbelowdot")
  print print_numeric_define("GDK_Abelowdot")
  print print_numeric_define("GDK_abelowdot")
  print print_numeric_define("GDK_Ahook")
  print print_numeric_define("GDK_ahook")
  print print_numeric_define("GDK_Acircumflexacute")
  print print_numeric_define("GDK_acircumflexacute")
  print print_numeric_define("GDK_Acircumflexgrave")
  print print_numeric_define("GDK_acircumflexgrave")
  print print_numeric_define("GDK_Acircumflexhook")
  print print_numeric_define("GDK_acircumflexhook")
  print print_numeric_define("GDK_Acircumflextilde")
  print print_numeric_define("GDK_acircumflextilde")
  print print_numeric_define("GDK_Acircumflexbelowdot")
  print print_numeric_define("GDK_acircumflexbelowdot")
  print print_numeric_define("GDK_Abreveacute")
  print print_numeric_define("GDK_abreveacute")
  print print_numeric_define("GDK_Abrevegrave")
  print print_numeric_define("GDK_abrevegrave")
  print print_numeric_define("GDK_Abrevehook")
  print print_numeric_define("GDK_abrevehook")
  print print_numeric_define("GDK_Abrevetilde")
  print print_numeric_define("GDK_abrevetilde")
  print print_numeric_define("GDK_Abrevebelowdot")
  print print_numeric_define("GDK_abrevebelowdot")
  print print_numeric_define("GDK_Ebelowdot")
  print print_numeric_define("GDK_ebelowdot")
  print print_numeric_define("GDK_Ehook")
  print print_numeric_define("GDK_ehook")
  print print_numeric_define("GDK_Etilde")
  print print_numeric_define("GDK_etilde")
  print print_numeric_define("GDK_Ecircumflexacute")
  print print_numeric_define("GDK_ecircumflexacute")
  print print_numeric_define("GDK_Ecircumflexgrave")
  print print_numeric_define("GDK_ecircumflexgrave")
  print print_numeric_define("GDK_Ecircumflexhook")
  print print_numeric_define("GDK_ecircumflexhook")
  print print_numeric_define("GDK_Ecircumflextilde")
  print print_numeric_define("GDK_ecircumflextilde")
  print print_numeric_define("GDK_Ecircumflexbelowdot")
  print print_numeric_define("GDK_ecircumflexbelowdot")
  print print_numeric_define("GDK_Ihook")
  print print_numeric_define("GDK_ihook")
  print print_numeric_define("GDK_Ibelowdot")
  print print_numeric_define("GDK_ibelowdot")
  print print_numeric_define("GDK_Obelowdot")
  print print_numeric_define("GDK_obelowdot")
  print print_numeric_define("GDK_Ohook")
  print print_numeric_define("GDK_ohook")
  print print_numeric_define("GDK_Ocircumflexacute")
  print print_numeric_define("GDK_ocircumflexacute")
  print print_numeric_define("GDK_Ocircumflexgrave")
  print print_numeric_define("GDK_ocircumflexgrave")
  print print_numeric_define("GDK_Ocircumflexhook")
  print print_numeric_define("GDK_ocircumflexhook")
  print print_numeric_define("GDK_Ocircumflextilde")
  print print_numeric_define("GDK_ocircumflextilde")
  print print_numeric_define("GDK_Ocircumflexbelowdot")
  print print_numeric_define("GDK_ocircumflexbelowdot")
  print print_numeric_define("GDK_Ohornacute")
  print print_numeric_define("GDK_ohornacute")
  print print_numeric_define("GDK_Ohorngrave")
  print print_numeric_define("GDK_ohorngrave")
  print print_numeric_define("GDK_Ohornhook")
  print print_numeric_define("GDK_ohornhook")
  print print_numeric_define("GDK_Ohorntilde")
  print print_numeric_define("GDK_ohorntilde")
  print print_numeric_define("GDK_Ohornbelowdot")
  print print_numeric_define("GDK_ohornbelowdot")
  print print_numeric_define("GDK_Ubelowdot")
  print print_numeric_define("GDK_ubelowdot")
  print print_numeric_define("GDK_Uhook")
  print print_numeric_define("GDK_uhook")
  print print_numeric_define("GDK_Uhornacute")
  print print_numeric_define("GDK_uhornacute")
  print print_numeric_define("GDK_Uhorngrave")
  print print_numeric_define("GDK_uhorngrave")
  print print_numeric_define("GDK_Uhornhook")
  print print_numeric_define("GDK_uhornhook")
  print print_numeric_define("GDK_Uhorntilde")
  print print_numeric_define("GDK_uhorntilde")
  print print_numeric_define("GDK_Uhornbelowdot")
  print print_numeric_define("GDK_uhornbelowdot")
  print print_numeric_define("GDK_Ybelowdot")
  print print_numeric_define("GDK_ybelowdot")
  print print_numeric_define("GDK_Yhook")
  print print_numeric_define("GDK_yhook")
  print print_numeric_define("GDK_Ytilde")
  print print_numeric_define("GDK_ytilde")
  print print_numeric_define("GDK_Ohorn")
  print print_numeric_define("GDK_ohorn")
  print print_numeric_define("GDK_Uhorn")
  print print_numeric_define("GDK_uhorn")
  print print_numeric_define("GDK_EcuSign")
  print print_numeric_define("GDK_ColonSign")
  print print_numeric_define("GDK_CruzeiroSign")
  print print_numeric_define("GDK_FFrancSign")
  print print_numeric_define("GDK_LiraSign")
  print print_numeric_define("GDK_MillSign")
  print print_numeric_define("GDK_NairaSign")
  print print_numeric_define("GDK_PesetaSign")
  print print_numeric_define("GDK_RupeeSign")
  print print_numeric_define("GDK_WonSign")
  print print_numeric_define("GDK_NewSheqelSign")
  print print_numeric_define("GDK_DongSign")
  print print_numeric_define("GDK_EuroSign")
  print print_numeric_define("GDK_zerosuperior")
  print print_numeric_define("GDK_foursuperior")
  print print_numeric_define("GDK_fivesuperior")
  print print_numeric_define("GDK_sixsuperior")
  print print_numeric_define("GDK_sevensuperior")
  print print_numeric_define("GDK_eightsuperior")
  print print_numeric_define("GDK_ninesuperior")
  print print_numeric_define("GDK_zerosubscript")
  print print_numeric_define("GDK_onesubscript")
  print print_numeric_define("GDK_twosubscript")
  print print_numeric_define("GDK_threesubscript")
  print print_numeric_define("GDK_foursubscript")
  print print_numeric_define("GDK_fivesubscript")
  print print_numeric_define("GDK_sixsubscript")
  print print_numeric_define("GDK_sevensubscript")
  print print_numeric_define("GDK_eightsubscript")
  print print_numeric_define("GDK_ninesubscript")
  print print_numeric_define("GDK_partdifferential")
  print print_numeric_define("GDK_emptyset")
  print print_numeric_define("GDK_elementof")
  print print_numeric_define("GDK_notelementof")
  print print_numeric_define("GDK_containsas")
  print print_numeric_define("GDK_squareroot")
  print print_numeric_define("GDK_cuberoot")
  print print_numeric_define("GDK_fourthroot")
  print print_numeric_define("GDK_dintegral")
  print print_numeric_define("GDK_tintegral")
  print print_numeric_define("GDK_because")
  print print_numeric_define("GDK_approxeq")
  print print_numeric_define("GDK_notapproxeq")
  print print_numeric_define("GDK_notidentical")
  print print_numeric_define("GDK_stricteq")
  print print_numeric_define("GDK_braille_dot_1")
  print print_numeric_define("GDK_braille_dot_2")
  print print_numeric_define("GDK_braille_dot_3")
  print print_numeric_define("GDK_braille_dot_4")
  print print_numeric_define("GDK_braille_dot_5")
  print print_numeric_define("GDK_braille_dot_6")
  print print_numeric_define("GDK_braille_dot_7")
  print print_numeric_define("GDK_braille_dot_8")
  print print_numeric_define("GDK_braille_dot_9")
  print print_numeric_define("GDK_braille_dot_10")
  print print_numeric_define("GDK_braille_blank")
  print print_numeric_define("GDK_braille_dots_1")
  print print_numeric_define("GDK_braille_dots_2")
  print print_numeric_define("GDK_braille_dots_12")
  print print_numeric_define("GDK_braille_dots_3")
  print print_numeric_define("GDK_braille_dots_13")
  print print_numeric_define("GDK_braille_dots_23")
  print print_numeric_define("GDK_braille_dots_123")
  print print_numeric_define("GDK_braille_dots_4")
  print print_numeric_define("GDK_braille_dots_14")
  print print_numeric_define("GDK_braille_dots_24")
  print print_numeric_define("GDK_braille_dots_124")
  print print_numeric_define("GDK_braille_dots_34")
  print print_numeric_define("GDK_braille_dots_134")
  print print_numeric_define("GDK_braille_dots_234")
  print print_numeric_define("GDK_braille_dots_1234")
  print print_numeric_define("GDK_braille_dots_5")
  print print_numeric_define("GDK_braille_dots_15")
  print print_numeric_define("GDK_braille_dots_25")
  print print_numeric_define("GDK_braille_dots_125")
  print print_numeric_define("GDK_braille_dots_35")
  print print_numeric_define("GDK_braille_dots_135")
  print print_numeric_define("GDK_braille_dots_235")
  print print_numeric_define("GDK_braille_dots_1235")
  print print_numeric_define("GDK_braille_dots_45")
  print print_numeric_define("GDK_braille_dots_145")
  print print_numeric_define("GDK_braille_dots_245")
  print print_numeric_define("GDK_braille_dots_1245")
  print print_numeric_define("GDK_braille_dots_345")
  print print_numeric_define("GDK_braille_dots_1345")
  print print_numeric_define("GDK_braille_dots_2345")
  print print_numeric_define("GDK_braille_dots_12345")
  print print_numeric_define("GDK_braille_dots_6")
  print print_numeric_define("GDK_braille_dots_16")
  print print_numeric_define("GDK_braille_dots_26")
  print print_numeric_define("GDK_braille_dots_126")
  print print_numeric_define("GDK_braille_dots_36")
  print print_numeric_define("GDK_braille_dots_136")
  print print_numeric_define("GDK_braille_dots_236")
  print print_numeric_define("GDK_braille_dots_1236")
  print print_numeric_define("GDK_braille_dots_46")
  print print_numeric_define("GDK_braille_dots_146")
  print print_numeric_define("GDK_braille_dots_246")
  print print_numeric_define("GDK_braille_dots_1246")
  print print_numeric_define("GDK_braille_dots_346")
  print print_numeric_define("GDK_braille_dots_1346")
  print print_numeric_define("GDK_braille_dots_2346")
  print print_numeric_define("GDK_braille_dots_12346")
  print print_numeric_define("GDK_braille_dots_56")
  print print_numeric_define("GDK_braille_dots_156")
  print print_numeric_define("GDK_braille_dots_256")
  print print_numeric_define("GDK_braille_dots_1256")
  print print_numeric_define("GDK_braille_dots_356")
  print print_numeric_define("GDK_braille_dots_1356")
  print print_numeric_define("GDK_braille_dots_2356")
  print print_numeric_define("GDK_braille_dots_12356")
  print print_numeric_define("GDK_braille_dots_456")
  print print_numeric_define("GDK_braille_dots_1456")
  print print_numeric_define("GDK_braille_dots_2456")
  print print_numeric_define("GDK_braille_dots_12456")
  print print_numeric_define("GDK_braille_dots_3456")
  print print_numeric_define("GDK_braille_dots_13456")
  print print_numeric_define("GDK_braille_dots_23456")
  print print_numeric_define("GDK_braille_dots_123456")
  print print_numeric_define("GDK_braille_dots_7")
  print print_numeric_define("GDK_braille_dots_17")
  print print_numeric_define("GDK_braille_dots_27")
  print print_numeric_define("GDK_braille_dots_127")
  print print_numeric_define("GDK_braille_dots_37")
  print print_numeric_define("GDK_braille_dots_137")
  print print_numeric_define("GDK_braille_dots_237")
  print print_numeric_define("GDK_braille_dots_1237")
  print print_numeric_define("GDK_braille_dots_47")
  print print_numeric_define("GDK_braille_dots_147")
  print print_numeric_define("GDK_braille_dots_247")
  print print_numeric_define("GDK_braille_dots_1247")
  print print_numeric_define("GDK_braille_dots_347")
  print print_numeric_define("GDK_braille_dots_1347")
  print print_numeric_define("GDK_braille_dots_2347")
  print print_numeric_define("GDK_braille_dots_12347")
  print print_numeric_define("GDK_braille_dots_57")
  print print_numeric_define("GDK_braille_dots_157")
  print print_numeric_define("GDK_braille_dots_257")
  print print_numeric_define("GDK_braille_dots_1257")
  print print_numeric_define("GDK_braille_dots_357")
  print print_numeric_define("GDK_braille_dots_1357")
  print print_numeric_define("GDK_braille_dots_2357")
  print print_numeric_define("GDK_braille_dots_12357")
  print print_numeric_define("GDK_braille_dots_457")
  print print_numeric_define("GDK_braille_dots_1457")
  print print_numeric_define("GDK_braille_dots_2457")
  print print_numeric_define("GDK_braille_dots_12457")
  print print_numeric_define("GDK_braille_dots_3457")
  print print_numeric_define("GDK_braille_dots_13457")
  print print_numeric_define("GDK_braille_dots_23457")
  print print_numeric_define("GDK_braille_dots_123457")
  print print_numeric_define("GDK_braille_dots_67")
  print print_numeric_define("GDK_braille_dots_167")
  print print_numeric_define("GDK_braille_dots_267")
  print print_numeric_define("GDK_braille_dots_1267")
  print print_numeric_define("GDK_braille_dots_367")
  print print_numeric_define("GDK_braille_dots_1367")
  print print_numeric_define("GDK_braille_dots_2367")
  print print_numeric_define("GDK_braille_dots_12367")
  print print_numeric_define("GDK_braille_dots_467")
  print print_numeric_define("GDK_braille_dots_1467")
  print print_numeric_define("GDK_braille_dots_2467")
  print print_numeric_define("GDK_braille_dots_12467")
  print print_numeric_define("GDK_braille_dots_3467")
  print print_numeric_define("GDK_braille_dots_13467")
  print print_numeric_define("GDK_braille_dots_23467")
  print print_numeric_define("GDK_braille_dots_123467")
  print print_numeric_define("GDK_braille_dots_567")
  print print_numeric_define("GDK_braille_dots_1567")
  print print_numeric_define("GDK_braille_dots_2567")
  print print_numeric_define("GDK_braille_dots_12567")
  print print_numeric_define("GDK_braille_dots_3567")
  print print_numeric_define("GDK_braille_dots_13567")
  print print_numeric_define("GDK_braille_dots_23567")
  print print_numeric_define("GDK_braille_dots_123567")
  print print_numeric_define("GDK_braille_dots_4567")
  print print_numeric_define("GDK_braille_dots_14567")
  print print_numeric_define("GDK_braille_dots_24567")
  print print_numeric_define("GDK_braille_dots_124567")
  print print_numeric_define("GDK_braille_dots_34567")
  print print_numeric_define("GDK_braille_dots_134567")
  print print_numeric_define("GDK_braille_dots_234567")
  print print_numeric_define("GDK_braille_dots_1234567")
  print print_numeric_define("GDK_braille_dots_8")
  print print_numeric_define("GDK_braille_dots_18")
  print print_numeric_define("GDK_braille_dots_28")
  print print_numeric_define("GDK_braille_dots_128")
  print print_numeric_define("GDK_braille_dots_38")
  print print_numeric_define("GDK_braille_dots_138")
  print print_numeric_define("GDK_braille_dots_238")
  print print_numeric_define("GDK_braille_dots_1238")
  print print_numeric_define("GDK_braille_dots_48")
  print print_numeric_define("GDK_braille_dots_148")
  print print_numeric_define("GDK_braille_dots_248")
  print print_numeric_define("GDK_braille_dots_1248")
  print print_numeric_define("GDK_braille_dots_348")
  print print_numeric_define("GDK_braille_dots_1348")
  print print_numeric_define("GDK_braille_dots_2348")
  print print_numeric_define("GDK_braille_dots_12348")
  print print_numeric_define("GDK_braille_dots_58")
  print print_numeric_define("GDK_braille_dots_158")
  print print_numeric_define("GDK_braille_dots_258")
  print print_numeric_define("GDK_braille_dots_1258")
  print print_numeric_define("GDK_braille_dots_358")
  print print_numeric_define("GDK_braille_dots_1358")
  print print_numeric_define("GDK_braille_dots_2358")
  print print_numeric_define("GDK_braille_dots_12358")
  print print_numeric_define("GDK_braille_dots_458")
  print print_numeric_define("GDK_braille_dots_1458")
  print print_numeric_define("GDK_braille_dots_2458")
  print print_numeric_define("GDK_braille_dots_12458")
  print print_numeric_define("GDK_braille_dots_3458")
  print print_numeric_define("GDK_braille_dots_13458")
  print print_numeric_define("GDK_braille_dots_23458")
  print print_numeric_define("GDK_braille_dots_123458")
  print print_numeric_define("GDK_braille_dots_68")
  print print_numeric_define("GDK_braille_dots_168")
  print print_numeric_define("GDK_braille_dots_268")
  print print_numeric_define("GDK_braille_dots_1268")
  print print_numeric_define("GDK_braille_dots_368")
  print print_numeric_define("GDK_braille_dots_1368")
  print print_numeric_define("GDK_braille_dots_2368")
  print print_numeric_define("GDK_braille_dots_12368")
  print print_numeric_define("GDK_braille_dots_468")
  print print_numeric_define("GDK_braille_dots_1468")
  print print_numeric_define("GDK_braille_dots_2468")
  print print_numeric_define("GDK_braille_dots_12468")
  print print_numeric_define("GDK_braille_dots_3468")
  print print_numeric_define("GDK_braille_dots_13468")
  print print_numeric_define("GDK_braille_dots_23468")
  print print_numeric_define("GDK_braille_dots_123468")
  print print_numeric_define("GDK_braille_dots_568")
  print print_numeric_define("GDK_braille_dots_1568")
  print print_numeric_define("GDK_braille_dots_2568")
  print print_numeric_define("GDK_braille_dots_12568")
  print print_numeric_define("GDK_braille_dots_3568")
  print print_numeric_define("GDK_braille_dots_13568")
  print print_numeric_define("GDK_braille_dots_23568")
  print print_numeric_define("GDK_braille_dots_123568")
  print print_numeric_define("GDK_braille_dots_4568")
  print print_numeric_define("GDK_braille_dots_14568")
  print print_numeric_define("GDK_braille_dots_24568")
  print print_numeric_define("GDK_braille_dots_124568")
  print print_numeric_define("GDK_braille_dots_34568")
  print print_numeric_define("GDK_braille_dots_134568")
  print print_numeric_define("GDK_braille_dots_234568")
  print print_numeric_define("GDK_braille_dots_1234568")
  print print_numeric_define("GDK_braille_dots_78")
  print print_numeric_define("GDK_braille_dots_178")
  print print_numeric_define("GDK_braille_dots_278")
  print print_numeric_define("GDK_braille_dots_1278")
  print print_numeric_define("GDK_braille_dots_378")
  print print_numeric_define("GDK_braille_dots_1378")
  print print_numeric_define("GDK_braille_dots_2378")
  print print_numeric_define("GDK_braille_dots_12378")
  print print_numeric_define("GDK_braille_dots_478")
  print print_numeric_define("GDK_braille_dots_1478")
  print print_numeric_define("GDK_braille_dots_2478")
  print print_numeric_define("GDK_braille_dots_12478")
  print print_numeric_define("GDK_braille_dots_3478")
  print print_numeric_define("GDK_braille_dots_13478")
  print print_numeric_define("GDK_braille_dots_23478")
  print print_numeric_define("GDK_braille_dots_123478")
  print print_numeric_define("GDK_braille_dots_578")
  print print_numeric_define("GDK_braille_dots_1578")
  print print_numeric_define("GDK_braille_dots_2578")
  print print_numeric_define("GDK_braille_dots_12578")
  print print_numeric_define("GDK_braille_dots_3578")
  print print_numeric_define("GDK_braille_dots_13578")
  print print_numeric_define("GDK_braille_dots_23578")
  print print_numeric_define("GDK_braille_dots_123578")
  print print_numeric_define("GDK_braille_dots_4578")
  print print_numeric_define("GDK_braille_dots_14578")
  print print_numeric_define("GDK_braille_dots_24578")
  print print_numeric_define("GDK_braille_dots_124578")
  print print_numeric_define("GDK_braille_dots_34578")
  print print_numeric_define("GDK_braille_dots_134578")
  print print_numeric_define("GDK_braille_dots_234578")
  print print_numeric_define("GDK_braille_dots_1234578")
  print print_numeric_define("GDK_braille_dots_678")
  print print_numeric_define("GDK_braille_dots_1678")
  print print_numeric_define("GDK_braille_dots_2678")
  print print_numeric_define("GDK_braille_dots_12678")
  print print_numeric_define("GDK_braille_dots_3678")
  print print_numeric_define("GDK_braille_dots_13678")
  print print_numeric_define("GDK_braille_dots_23678")
  print print_numeric_define("GDK_braille_dots_123678")
  print print_numeric_define("GDK_braille_dots_4678")
  print print_numeric_define("GDK_braille_dots_14678")
  print print_numeric_define("GDK_braille_dots_24678")
  print print_numeric_define("GDK_braille_dots_124678")
  print print_numeric_define("GDK_braille_dots_34678")
  print print_numeric_define("GDK_braille_dots_134678")
  print print_numeric_define("GDK_braille_dots_234678")
  print print_numeric_define("GDK_braille_dots_1234678")
  print print_numeric_define("GDK_braille_dots_5678")
  print print_numeric_define("GDK_braille_dots_15678")
  print print_numeric_define("GDK_braille_dots_25678")
  print print_numeric_define("GDK_braille_dots_125678")
  print print_numeric_define("GDK_braille_dots_35678")
  print print_numeric_define("GDK_braille_dots_135678")
  print print_numeric_define("GDK_braille_dots_235678")
  print print_numeric_define("GDK_braille_dots_1235678")
  print print_numeric_define("GDK_braille_dots_45678")
  print print_numeric_define("GDK_braille_dots_145678")
  print print_numeric_define("GDK_braille_dots_245678")
  print print_numeric_define("GDK_braille_dots_1245678")
  print print_numeric_define("GDK_braille_dots_345678")
  print print_numeric_define("GDK_braille_dots_1345678")
  print print_numeric_define("GDK_braille_dots_2345678")
  print print_numeric_define("GDK_braille_dots_12345678")
  print print_numeric_define("GDK_ModeLock")
  print print_numeric_define("GDK_MonBrightnessUp")
  print print_numeric_define("GDK_MonBrightnessDown")
  print print_numeric_define("GDK_KbdLightOnOff")
  print print_numeric_define("GDK_KbdBrightnessUp")
  print print_numeric_define("GDK_KbdBrightnessDown")
  print print_numeric_define("GDK_Standby")
  print print_numeric_define("GDK_AudioLowerVolume")
  print print_numeric_define("GDK_AudioMute")
  print print_numeric_define("GDK_AudioRaiseVolume")
  print print_numeric_define("GDK_AudioPlay")
  print print_numeric_define("GDK_AudioStop")
  print print_numeric_define("GDK_AudioPrev")
  print print_numeric_define("GDK_AudioNext")
  print print_numeric_define("GDK_HomePage")
  print print_numeric_define("GDK_Mail")
  print print_numeric_define("GDK_Start")
  print print_numeric_define("GDK_Search")
  print print_numeric_define("GDK_AudioRecord")
  print print_numeric_define("GDK_Calculator")
  print print_numeric_define("GDK_Memo")
  print print_numeric_define("GDK_ToDoList")
  print print_numeric_define("GDK_Calendar")
  print print_numeric_define("GDK_PowerDown")
  print print_numeric_define("GDK_ContrastAdjust")
  print print_numeric_define("GDK_RockerUp")
  print print_numeric_define("GDK_RockerDown")
  print print_numeric_define("GDK_RockerEnter")
  print print_numeric_define("GDK_Back")
  print print_numeric_define("GDK_Forward")
  print print_numeric_define("GDK_Stop")
  print print_numeric_define("GDK_Refresh")
  print print_numeric_define("GDK_PowerOff")
  print print_numeric_define("GDK_WakeUp")
  print print_numeric_define("GDK_Eject")
  print print_numeric_define("GDK_ScreenSaver")
  print print_numeric_define("GDK_WWW")
  print print_numeric_define("GDK_Sleep")
  print print_numeric_define("GDK_Favorites")
  print print_numeric_define("GDK_AudioPause")
  print print_numeric_define("GDK_AudioMedia")
  print print_numeric_define("GDK_MyComputer")
  print print_numeric_define("GDK_VendorHome")
  print print_numeric_define("GDK_LightBulb")
  print print_numeric_define("GDK_Shop")
  print print_numeric_define("GDK_History")
  print print_numeric_define("GDK_OpenURL")
  print print_numeric_define("GDK_AddFavorite")
  print print_numeric_define("GDK_HotLinks")
  print print_numeric_define("GDK_BrightnessAdjust")
  print print_numeric_define("GDK_Finance")
  print print_numeric_define("GDK_Community")
  print print_numeric_define("GDK_AudioRewind")
  print print_numeric_define("GDK_BackForward")
  print print_numeric_define("GDK_Launch0")
  print print_numeric_define("GDK_Launch1")
  print print_numeric_define("GDK_Launch2")
  print print_numeric_define("GDK_Launch3")
  print print_numeric_define("GDK_Launch4")
  print print_numeric_define("GDK_Launch5")
  print print_numeric_define("GDK_Launch6")
  print print_numeric_define("GDK_Launch7")
  print print_numeric_define("GDK_Launch8")
  print print_numeric_define("GDK_Launch9")
  print print_numeric_define("GDK_LaunchA")
  print print_numeric_define("GDK_LaunchB")
  print print_numeric_define("GDK_LaunchC")
  print print_numeric_define("GDK_LaunchD")
  print print_numeric_define("GDK_LaunchE")
  print print_numeric_define("GDK_LaunchF")
  print print_numeric_define("GDK_ApplicationLeft")
  print print_numeric_define("GDK_ApplicationRight")
  print print_numeric_define("GDK_Book")
  print print_numeric_define("GDK_CD")
  print print_numeric_define("GDK_WindowClear")
  print print_numeric_define("GDK_Close")
  print print_numeric_define("GDK_Copy")
  print print_numeric_define("GDK_Cut")
  print print_numeric_define("GDK_Display")
  print print_numeric_define("GDK_DOS")
  print print_numeric_define("GDK_Documents")
  print print_numeric_define("GDK_Excel")
  print print_numeric_define("GDK_Explorer")
  print print_numeric_define("GDK_Game")
  print print_numeric_define("GDK_Go")
  print print_numeric_define("GDK_iTouch")
  print print_numeric_define("GDK_LogOff")
  print print_numeric_define("GDK_Market")
  print print_numeric_define("GDK_Meeting")
  print print_numeric_define("GDK_MenuKB")
  print print_numeric_define("GDK_MenuPB")
  print print_numeric_define("GDK_MySites")
  print print_numeric_define("GDK_New")
  print print_numeric_define("GDK_News")
  print print_numeric_define("GDK_OfficeHome")
  print print_numeric_define("GDK_Open")
  print print_numeric_define("GDK_Option")
  print print_numeric_define("GDK_Paste")
  print print_numeric_define("GDK_Phone")
  print print_numeric_define("GDK_Reply")
  print print_numeric_define("GDK_Reload")
  print print_numeric_define("GDK_RotateWindows")
  print print_numeric_define("GDK_RotationPB")
  print print_numeric_define("GDK_RotationKB")
  print print_numeric_define("GDK_Save")
  print print_numeric_define("GDK_ScrollUp")
  print print_numeric_define("GDK_ScrollDown")
  print print_numeric_define("GDK_ScrollClick")
  print print_numeric_define("GDK_Send")
  print print_numeric_define("GDK_Spell")
  print print_numeric_define("GDK_SplitScreen")
  print print_numeric_define("GDK_Support")
  print print_numeric_define("GDK_TaskPane")
  print print_numeric_define("GDK_Terminal")
  print print_numeric_define("GDK_Tools")
  print print_numeric_define("GDK_Travel")
  print print_numeric_define("GDK_UserPB")
  print print_numeric_define("GDK_User1KB")
  print print_numeric_define("GDK_User2KB")
  print print_numeric_define("GDK_Video")
  print print_numeric_define("GDK_WheelButton")
  print print_numeric_define("GDK_Word")
  print print_numeric_define("GDK_Xfer")
  print print_numeric_define("GDK_ZoomIn")
  print print_numeric_define("GDK_ZoomOut")
  print print_numeric_define("GDK_Away")
  print print_numeric_define("GDK_Messenger")
  print print_numeric_define("GDK_WebCam")
  print print_numeric_define("GDK_MailForward")
  print print_numeric_define("GDK_Pictures")
  print print_numeric_define("GDK_Music")
  print print_numeric_define("GDK_Battery")
  print print_numeric_define("GDK_Bluetooth")
  print print_numeric_define("GDK_WLAN")
  print print_numeric_define("GDK_UWB")
  print print_numeric_define("GDK_AudioForward")
  print print_numeric_define("GDK_AudioRepeat")
  print print_numeric_define("GDK_AudioRandomPlay")
  print print_numeric_define("GDK_Subtitle")
  print print_numeric_define("GDK_AudioCycleTrack")
  print print_numeric_define("GDK_CycleAngle")
  print print_numeric_define("GDK_FrameBack")
  print print_numeric_define("GDK_FrameForward")
  print print_numeric_define("GDK_Time")
  print print_numeric_define("GDK_SelectButton")
  print print_numeric_define("GDK_View")
  print print_numeric_define("GDK_TopMenu")
  print print_numeric_define("GDK_Red")
  print print_numeric_define("GDK_Green")
  print print_numeric_define("GDK_Yellow")
  print print_numeric_define("GDK_Blue")
  print print_numeric_define("GDK_Suspend")
  print print_numeric_define("GDK_Hibernate")
  print print_numeric_define("GDK_TouchpadToggle")
  print print_numeric_define("GDK_Switch_VT_1")
  print print_numeric_define("GDK_Switch_VT_2")
  print print_numeric_define("GDK_Switch_VT_3")
  print print_numeric_define("GDK_Switch_VT_4")
  print print_numeric_define("GDK_Switch_VT_5")
  print print_numeric_define("GDK_Switch_VT_6")
  print print_numeric_define("GDK_Switch_VT_7")
  print print_numeric_define("GDK_Switch_VT_8")
  print print_numeric_define("GDK_Switch_VT_9")
  print print_numeric_define("GDK_Switch_VT_10")
  print print_numeric_define("GDK_Switch_VT_11")
  print print_numeric_define("GDK_Switch_VT_12")
  print print_numeric_define("GDK_Ungrab")
  print print_numeric_define("GDK_ClearGrab")
  print print_numeric_define("GDK_Next_VMode")
  print print_numeric_define("GDK_Prev_VMode")
  print print_end_of_category()

  print "  exit(0);"
  print "}"
}

function print_end_of_category()
{
  return "  printf(\" !\\n\\n\");"
}

function print_numeric_define(c_name)
{
  selector = smalltalkize(tolower(c_name))
  return "#ifdef " c_name "\n  printf(\"\\n" selector " ^%d!\", (int) " c_name ");\n#endif"
}

function print_numeric_enum(c_name)
{
  selector = smalltalkize(tolower(c_name))
  return "  printf(\"\\n" selector " ^%d!\", (int) " c_name ");"
}

function print_string_enum(c_name)
{
  selector = smalltalkize(tolower(c_name))
  return "  printf(\"\\n" selector " ^'%s'!\", " c_name ");"
}

function print_methodsFor( class, category )
{
  return "  printf(\"!" class " class methodsFor: '" category "'!\\n\");"
}
function get_enum_class( res )
{
  if (tolower (res) ~ /pango/) return "Pango"
  if (tolower (res) ~ /gdk/) return "Gdk"
  if (tolower (res) ~ /gtk/) return "Gtk"
  if (tolower (res) ~ /atk/) return "Atk"
  if (tolower (res) ~ /g/) return "GLib"
  return ""
}

function smalltalkize( res )
{
  first = substr (res, 1, 1)
  res = tolower( substr (res, 2) )

  while (i = index (res, "_")) {
    first = first substr(res, 1, i - 1) toupper( substr (res, i + 1, 1))
    res = substr (res, i + 2)
  }

  return first res
}
